/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.lang.CharBinaryBuffer;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class BinaryUtils {
    private static final byte[] ZERO_BYTES = new byte[0];

    public static int findFirst(byte[] str1, char charToFind) {
        return BinaryUtils.findFirst(str1, charToFind, 0);
    }

    public static int findFirst(byte[] str1, char charToFind, int start_index) {
        if (str1 == null) {
            return -1;
        }
        return BinaryUtils.indexOf(str1, charToFind, start_index);
    }

    public static int findFirst(byte[] str1, String toFind) {
        return BinaryUtils.findFirst(str1, toFind, 0);
    }

    public static int findFirst(byte[] str1, String toFind, int start_index) {
        if (str1 == null) {
            return -1;
        }
        byte[] sequence = toFind.getBytes();
        return BinaryUtils.indexOf(str1, sequence, start_index);
    }

    private static byte[][] prepareByteSequences(List toFind, String encoding) throws UnsupportedEncodingException {
        byte[][] sequences = new byte[toFind.size()][];
        for (int i = 0; i < toFind.size(); ++i) {
            String s = (String)toFind.get(i);
            byte[] sequence = CharBinaryBuffer.stringToBytes(s, encoding);
            sequences[i] = sequence;
        }
        return sequences;
    }

    private static int indexOf(byte[] str1, int charToFind, int start_index) {
        int length = BinaryUtils.getLength(str1);
        for (int i = start_index; i < length; ++i) {
            byte b = str1[i];
            if (b != charToFind) continue;
            return i;
        }
        return -1;
    }

    private static int getLength(byte[] str1) {
        return str1 == null ? 0 : str1.length;
    }

    private static int indexOf(byte[] str1, byte[] sequence, int start_index) {
        if (sequence.length > 0) {
            for (int i = start_index = Math.max(start_index, 0); i < str1.length; ++i) {
                byte b = str1[i];
                if (b != sequence[0] || !BinaryUtils.isSequenceMatch(str1, i, sequence)) continue;
                return i;
            }
        }
        return -1;
    }

    private static int indexOf(byte[] str1, byte[][] sequences, int start_index) {
        int length = str1.length;
        for (int i = start_index = Math.max(start_index, 0); i < length; ++i) {
            byte b = str1[i];
            for (int j = 0; j < sequences.length; ++j) {
                byte[] sequence = sequences[j];
                if (sequence.length <= 0 || b != sequence[0] || !BinaryUtils.isSequenceMatch(str1, i, sequence)) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean isSequenceMatch(byte[] str1, int index, byte[] sequence) {
        int length = str1.length;
        for (int i = index; i < index + sequence.length; ++i) {
            if (i < length) {
                if (str1[i] == sequence[i - index]) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static byte[] mid(byte[] v1, int start_index) {
        return BinaryUtils.mid(v1, start_index, v1.length - start_index);
    }

    public static byte[] mid(byte[] v1, int start_index, int num_chars) {
        if (start_index < 0) {
            start_index = 0;
        }
        if (num_chars < 0) {
            return ZERO_BYTES;
        }
        int strLength = v1.length;
        if (start_index >= strLength) {
            return ZERO_BYTES;
        }
        num_chars = Math.min(num_chars, strLength - start_index);
        byte[] toRet = new byte[num_chars];
        System.arraycopy(v1, start_index, toRet, 0, num_chars);
        return toRet;
    }
}

