/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class CalendarParser {
    private final String format;
    private final String value;
    private final int flen;
    private final int vlen;
    private int fidx;
    private int vidx;
    public int hour = 0;
    public int minute = 0;
    public int seconds = 0;
    public int milliSecond = 0;
    private static final Date PURE_GREGORIAN_CHANGE = new Date(Long.MIN_VALUE);
    public static final TimeZone DEFAULT_TIMEZONE = (TimeZone)TimeZone.getDefault().clone();
    private static final BigDecimal DECIMAL_ZERO = new BigDecimal("0");
    private static final BigDecimal DECIMAL_ONE = new BigDecimal("1");
    private static final BigDecimal DECIMAL_SIXTY = new BigDecimal("60");

    public CalendarParser(String format, String value) {
        this.format = format;
        this.value = value;
        this.flen = format.length();
        this.vlen = value.length();
    }

    public static TimeZone getDefaultTimezone() {
        return DEFAULT_TIMEZONE;
    }

    public static GregorianCalendar createGregorianCalendar() {
        GregorianCalendar gc = new GregorianCalendar(DEFAULT_TIMEZONE);
        gc.clear();
        gc.setGregorianChange(PURE_GREGORIAN_CHANGE);
        return gc;
    }

    public static Calendar parse(String format, String value) throws IllegalArgumentException {
        return new CalendarParser(format, value).parse(false);
    }

    public static Calendar parse(String format, String value, boolean allowEndOfDay) throws IllegalArgumentException {
        return new CalendarParser(format, value).parse(allowEndOfDay);
    }

    public static Date parseAsDate(String format, String value) throws IllegalArgumentException {
        return new CalendarParser(format, value).parse().getTime();
    }

    public Calendar parse() throws IllegalArgumentException {
        return this.parse(false);
    }

    public Calendar parse(boolean allowEndOfDay) throws IllegalArgumentException {
        GregorianCalendar cal = CalendarParser.createGregorianCalendar();
        cal.setLenient(false);
        block11: while (this.fidx < this.flen) {
            char fch;
            if ((fch = this.format.charAt(this.fidx++)) != '%') {
                this.skip(fch);
                continue;
            }
            switch (this.format.charAt(this.fidx++)) {
                case 'Y': {
                    this.setYear(cal, this.parseBigInteger(4));
                    continue block11;
                }
                case 'M': {
                    cal.set(2, this.parseInt(2, 2, "Month") - 1);
                    continue block11;
                }
                case 'D': {
                    cal.set(5, this.parseInt(2, 2, "Days"));
                    continue block11;
                }
                case 'h': {
                    this.hour = this.parseInt(2, 2, "hours");
                    if (allowEndOfDay && this.hour == 24) continue block11;
                    cal.set(11, this.hour);
                    continue block11;
                }
                case 'm': {
                    this.minute = this.parseInt(2, 2, "minutes");
                    cal.set(12, this.minute);
                    continue block11;
                }
                case 's': {
                    this.seconds = this.parseInt(2, 2, "seconds");
                    if (this.seconds == 60) {
                        cal.setLenient(true);
                    }
                    cal.set(13, this.seconds);
                    if (this.peek() != '.') continue block11;
                    this.setFractionalSecond((Calendar)cal, this.parseBigDecimal());
                    continue block11;
                }
                case 'z': {
                    char vch = this.peek();
                    if (vch == 'Z') {
                        ++this.vidx;
                        this.setTimezone(cal, 0);
                        continue block11;
                    }
                    if (vch != '+' && vch != '-') continue block11;
                    ++this.vidx;
                    int h = this.parseInt(2, 2, "Timezone hours");
                    this.skip(':');
                    int m = this.parseInt(2, 2, "Timezone minutes");
                    this.setTimezone(cal, (h * 60 + m) * (vch == '+' ? 1 : -1));
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Illegal date/time format " + this.format);
        }
        if (this.vidx != this.vlen) {
            this.throwMismatch("Unexpected additional character in input");
        }
        try {
            if (allowEndOfDay) {
                this.setEndOfDayValue(cal);
            }
            cal.get(1);
        }
        catch (IllegalArgumentException e) {
            this.throwMismatch(e.getMessage());
        }
        cal.setLenient(false);
        return cal;
    }

    private void setEndOfDayValue(Calendar cal) {
        if (this.hour == 24 && (this.minute | this.seconds | this.milliSecond) == 0) {
            try {
                cal.get(1);
            }
            catch (IllegalArgumentException e) {
                this.throwMismatch(e.getMessage());
            }
            cal.setLenient(true);
        }
        cal.set(11, this.hour);
    }

    private void setTimezone(Calendar cal, int zoneOffset) {
        cal.setTimeZone(CalendarParser.getTimeZone(zoneOffset));
    }

    public void setFractionalSecond(Calendar cal, BigDecimal fractional) {
        if (fractional != null) {
            if (fractional.compareTo(DECIMAL_ZERO) < 0 || fractional.compareTo(DECIMAL_ONE) > 0) {
                this.throwMismatch("InvalidFractional " + fractional);
            }
            cal.set(14, fractional.movePointRight(3).intValue());
        }
    }

    public void setFractionalSecond(Calendar cal, double fractional) {
        int milliSecond;
        if (fractional < 0.0 || fractional > 1.0) {
            this.throwMismatch("InvalidFractional " + fractional);
        }
        this.milliSecond = milliSecond = (int)(fractional * 1000.0);
        cal.set(14, milliSecond);
    }

    public void setYear(Calendar cal, int year) {
        if (year == 0) {
            cal.clear(0);
            cal.clear(1);
        } else {
            cal.set(0, year < 0 ? 0 : 1);
            cal.set(1, Math.abs(year));
        }
    }

    public static TimeZone getTimeZone(int zoneoffset) {
        char sign;
        TimeZone result = null;
        char c = sign = zoneoffset < 0 ? (char)'-' : '+';
        if (sign == '-') {
            zoneoffset = -zoneoffset;
        }
        int hour = zoneoffset / 60;
        int minutes = zoneoffset - hour * 60;
        StringBuffer customTimezoneId = new StringBuffer(8);
        customTimezoneId.append("GMT");
        customTimezoneId.append(sign);
        customTimezoneId.append(CalendarParser.lpad(Integer.toString(hour), '0', 2));
        if (minutes != 0) {
            customTimezoneId.append(CalendarParser.lpad(Integer.toString(minutes), '0', 2));
        }
        result = TimeZone.getTimeZone(customTimezoneId.toString());
        return result;
    }

    public static String lpad(String str, char pad_char, int max_chars) {
        if (max_chars < 0) {
            return str;
        }
        if (max_chars < str.length()) {
            return str.substring(0, max_chars);
        }
        if (max_chars == str.length()) {
            return str;
        }
        char[] chars = new char[max_chars - str.length()];
        Arrays.fill(chars, pad_char);
        return new String(chars) + str;
    }

    private char peek() throws IllegalArgumentException {
        if (this.vidx == this.vlen) {
            return '\uffff';
        }
        return this.value.charAt(this.vidx);
    }

    private char read() throws IllegalArgumentException {
        if (this.vidx == this.vlen) {
            this.throwMismatch();
        }
        return this.value.charAt(this.vidx++);
    }

    private void skip(char ch) throws IllegalArgumentException {
        if (this.read() != ch) {
            this.throwMismatch();
        }
    }

    private int parseInt(int minDigits, int maxDigits, String name) throws IllegalArgumentException {
        char ch;
        int n = 0;
        int vstart = this.vidx;
        while (CalendarParser.isDigit(ch = this.peek()) && this.vidx - vstart < maxDigits) {
            ++this.vidx;
            n = n * 10 + ch - 48;
        }
        if (this.vidx - vstart < minDigits) {
            this.throwMismatch("Truncated field " + name);
        }
        return n;
    }

    private int parseBigInteger(int minDigits) throws IllegalArgumentException {
        char ch;
        int vstart = this.vidx++;
        boolean neg = false;
        if (this.peek() == '-') {
            neg = true;
        }
        int n = 0;
        while (CalendarParser.isDigit(ch = this.peek())) {
            ++this.vidx;
            n = n * 10 + ch - 48;
        }
        if (this.vidx - vstart < minDigits) {
            this.throwMismatch();
        }
        if (neg) {
            n = -n;
        }
        return n;
    }

    private double parseBigDecimal() throws IllegalArgumentException {
        int vstart = this.vidx++;
        if (this.peek() != '.') {
            this.throwMismatch();
        }
        while (CalendarParser.isDigit(this.peek())) {
            ++this.vidx;
        }
        return Double.parseDouble(this.value.substring(vstart, this.vidx));
    }

    private static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    void throwMismatch() {
        this.throwMismatch(null);
    }

    void throwMismatch(String message) {
        String text = "Error parsing " + this.value + " in format " + this.format + ".";
        if (message != null) {
            text = text + " " + message;
        }
        throw new IllegalArgumentException(text);
    }

    public static void cmtmain(String[] args) {
        System.out.println(CalendarParser.parse("%Y-%M-%DT%h:%m:%s%z", "2007-03-27T10:15:25.12"));
        System.out.println(CalendarParser.parse("%Y-%M-%DT%h:%m:%s%z", "2007-03-27T10:15:25.120"));
        System.out.println(CalendarParser.parse("%Y-%M-%DT%h:%m:%s%z", "2007-03-27T10:15:25.2"));
        System.out.println(CalendarParser.parse("%Y-%M-%DT%h:%m:%s%z", "2007-03-27T10:15:25.002"));
        System.out.println(CalendarParser.parse("%Y-%M-%DT%h:%m:%s%z", "2007-03-27T10:15:25.4321"));
    }
}

