/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.lang.IllegalValueException;

public interface CharConverter {
    public static final CharConverter UNICODE_ESCAPE = new CharConverterImpl(true);
    public static final CharConverter NO_UNICODE_ESCAPE = new CharConverterImpl(false);
    public static final CharConverter STANDARD_ESCAPE = new CharConverterImpl(false, false);

    public String toLiteral(char var1);

    public String toLiteral(String var1) throws IllegalArgumentException;

    public String parseLiteral(String var1) throws IllegalValueException;

    public String parseLiteral(String var1, boolean var2) throws IllegalValueException;

    public static class CharConverterImpl
    implements CharConverter {
        boolean unicodeEscape;
        boolean nonASCIIEscape = true;

        private CharConverterImpl(boolean unicodeEscape) {
            this.unicodeEscape = unicodeEscape;
        }

        private CharConverterImpl(boolean unicodeEscape, boolean nonASCIIEscape) {
            this.unicodeEscape = unicodeEscape;
            this.nonASCIIEscape = nonASCIIEscape;
        }

        private CharConverterImpl() {
        }

        public boolean isUnicodeEscape() {
            return this.unicodeEscape;
        }

        public void setUnicodeEscape(boolean unicodeEscape) {
            this.unicodeEscape = unicodeEscape;
        }

        public String toLiteral(String javaString) throws IllegalArgumentException {
            if (javaString == null) {
                throw new IllegalArgumentException("Null value not allowed");
            }
            if (this.hasNonLiteral(javaString)) {
                StringBuffer toRet = new StringBuffer();
                for (int i = 0; i < javaString.length(); ++i) {
                    char c = javaString.charAt(i);
                    if (!CharConverterImpl.isLetterOrDigit(c)) {
                        toRet.append(this.toLiteral(c));
                        continue;
                    }
                    toRet.append(c);
                }
                return toRet.toString();
            }
            return javaString;
        }

        private boolean hasNonLiteral(String javaString) {
            for (int i = 0; i < javaString.length(); ++i) {
                char c = javaString.charAt(i);
                if (this.isASCIILetterOrDigit(c)) continue;
                return true;
            }
            return false;
        }

        private boolean isASCIILetterOrDigit(char c) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
        }

        public boolean hasNonASCII(String javaString) throws IllegalArgumentException {
            for (int i = 0; i < javaString.length(); ++i) {
                char c = javaString.charAt(i);
                if (c >= ' ' && c <= '\u007f') continue;
                return true;
            }
            return false;
        }

        public String toLiteral(char val) {
            String s = String.valueOf(val);
            if (val >= '\u007f' && this.nonASCIIEscape) {
                return "\\u" + CharConverterImpl.padZero(Integer.toString(val, 16), 4) + "";
            }
            switch (val) {
                case '\b': {
                    s = "\\b";
                    break;
                }
                case '\t': {
                    s = "\\t";
                    break;
                }
                case '\n': {
                    s = "\\n";
                    break;
                }
                case '\f': {
                    s = "\\f";
                    break;
                }
                case '\r': {
                    s = "\\r";
                    break;
                }
                case '\"': {
                    s = "\\\"";
                    break;
                }
                case '\'': {
                    s = "\\'";
                    break;
                }
                case '\\': {
                    s = "\\\\";
                    break;
                }
                default: {
                    if (val >= ' ' || !this.nonASCIIEscape) break;
                    if (this.unicodeEscape) {
                        return "\\u" + CharConverterImpl.padZero(Integer.toString(val, 16), 4) + "";
                    }
                    return "\\" + CharConverterImpl.padZero(Integer.toString(val, 8), 3);
                }
            }
            return s;
        }

        public String parseLiteral(String escapedString) throws IllegalValueException {
            return this.parseLiteral(escapedString, false);
        }

        public String parseLiteral(String escapedString, boolean toLiteral) throws IllegalValueException {
            if (escapedString == null) {
                return "";
            }
            StringBuffer toRet = new StringBuffer();
            for (int i = 0; i < escapedString.length(); ++i) {
                int c = escapedString.charAt(i);
                if (c == 92) {
                    if (i == escapedString.length() - 1) {
                        throw new IllegalValueException("Incomplete escape sequence (\\) in literal " + escapedString);
                    }
                    char firstChar = escapedString.charAt(++i);
                    switch (firstChar) {
                        case 'u': {
                            if (i + 4 >= escapedString.length()) {
                                throw new IllegalValueException("Illegal unicode escape sequence in " + escapedString);
                            }
                            char c1 = escapedString.charAt(++i);
                            char c2 = escapedString.charAt(++i);
                            char c3 = escapedString.charAt(++i);
                            char c4 = escapedString.charAt(++i);
                            if (CharConverterImpl.isHexDigit(c1) && CharConverterImpl.isHexDigit(c2) && CharConverterImpl.isHexDigit(c3) & CharConverterImpl.isHexDigit(c4)) {
                                c = (char)(CharConverterImpl.getHexValue(c1) * 4096 + CharConverterImpl.getHexValue(c2) * 256 + CharConverterImpl.getHexValue(c3) * 16 + CharConverterImpl.getHexValue(c4) * 1);
                                break;
                            }
                            throw new IllegalValueException("Illegal unicode escape sequence in " + escapedString);
                        }
                        case 'b': {
                            c = 8;
                            break;
                        }
                        case 't': {
                            c = 9;
                            break;
                        }
                        case 'n': {
                            c = 10;
                            break;
                        }
                        case 'r': {
                            c = 13;
                            break;
                        }
                        case 'f': {
                            c = 12;
                            break;
                        }
                        case '\"': {
                            c = 34;
                            break;
                        }
                        case '\'': {
                            c = 39;
                            break;
                        }
                        case '\\': {
                            c = 92;
                            break;
                        }
                        case '#': {
                            try {
                                char c2;
                                if (i > escapedString.length() - 2) {
                                    throw new IllegalValueException("Illegal escape sequence (\\x) in " + escapedString);
                                }
                                if (escapedString.charAt(++i) != 'x') {
                                    throw new IllegalValueException("Illegal escape sequence for delimiter " + escapedString);
                                }
                                int value = 0;
                                char c1 = escapedString.charAt(++i);
                                char c3 = c2 = i == escapedString.length() - 1 ? (char)'\u0000' : escapedString.charAt(i + 1);
                                if (CharConverterImpl.isHexDigit(c2)) {
                                    ++i;
                                    value = 16 * CharConverterImpl.getHexValue(c1) + CharConverterImpl.getHexValue(c2);
                                } else {
                                    value = CharConverterImpl.getHexValue(c1);
                                }
                                c = (char)value;
                                break;
                            }
                            catch (IllegalValueException e) {
                                throw new IllegalValueException("Unrecognized escape sequence (\\#x) in " + escapedString);
                            }
                        }
                        default: {
                            if (firstChar >= '0' && firstChar <= '7') {
                                char nChar;
                                int j;
                                for (j = i; j < i + 3 && j < escapedString.length() && (nChar = escapedString.charAt(j)) >= '0' && nChar <= '7'; ++j) {
                                }
                                String octalSequence = escapedString.substring(i, j);
                                c = (char)Integer.parseInt(octalSequence, 8);
                                i = j - 1;
                                break;
                            }
                            throw new IllegalValueException("Unrecognized escape sequence '\\" + firstChar + "' in " + escapedString);
                        }
                    }
                }
                if (toLiteral) {
                    toRet.append(this.toLiteral((char)c));
                    continue;
                }
                toRet.append((char)c);
            }
            return toRet.toString();
        }

        private static String padZero(String str, int maxLength) {
            while (str.length() < maxLength) {
                str = "0" + str;
            }
            return str;
        }

        private static boolean isLetterOrDigit(char c) {
            return c >= ' ' && c <= '\u007f' && Character.isLetterOrDigit(c);
        }

        private static boolean isHexDigit(char c) {
            return c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f' || c >= '0' && c <= '9';
        }

        private static int getHexValue(char c) throws IllegalValueException {
            if (c >= 'A' && c <= 'F') {
                return c - 65 + 10;
            }
            if (c >= 'a' && c <= 'f') {
                return c - 97 + 10;
            }
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            throw new IllegalValueException("Unexpected hex char " + c);
        }
    }
}

