/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.io.SafeFile;
import com.tplus.transform.util.GlobFilenameFilter;
import com.tplus.transform.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class ConvertEncoding {
    public static void main(String[] args) {
        int i;
        if (args.length < 3) {
            System.out.println("Syntax : convert-encoding srcEncoding destEncoding srcFile or folder .... ");
            System.out.println("Example: convert-encoding ISO-8859-1 CP1047 testFolder");
            return;
        }
        String srcEncoding = args[0];
        String destEncoding = args[1];
        ArrayList files = new ArrayList();
        for (i = 2; i < args.length; ++i) {
            String fileName = args[i];
            if (new File(fileName).isDirectory()) {
                List allFiles = IOUtil.getAllFiles(fileName, true);
                files.addAll(allFiles);
                continue;
            }
            File file = new File(fileName);
            String dir = file.getParent();
            String filter = file.getName();
            GlobFilenameFilter globFilenameFilter = new GlobFilenameFilter(filter);
            List allFiles = IOUtil.getAllFiles(dir, true, globFilenameFilter);
            files.addAll(allFiles);
        }
        for (i = 0; i < files.size(); ++i) {
            String arg = (String)files.get(i);
            String destFile = arg + ".encoded";
            String srcFile = arg;
            try {
                ConvertEncoding.convert(srcEncoding, destEncoding, srcFile, destFile);
                File file = new File(srcFile);
                file.delete();
                new File(destFile).renameTo(file);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convert(String srcEncoding, String destEncoding, String srcFile, String destFile) throws IOException, UnsupportedEncodingException {
        SafeFile.doFileCheck(srcFile);
        SafeFile.doFileCheck(destFile);
        InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(srcFile), srcEncoding);
        OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), destEncoding);
        char[] buffer = new char[2048];
        try {
            int read;
            while ((read = is.read(buffer)) != -1) {
                ((Writer)os).write(buffer, 0, read);
            }
        }
        finally {
            ((Reader)is).close();
            ((Writer)os).close();
        }
    }
}

