/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.lang.Wrapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtils {
    public static final String INTERNATIONAL_SHORT_DATE_FORMAT = "dd MMM yyyy";
    private static int milliSecInDays = 86400000;
    static String[] ab_day_nm = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static String[] day_nm = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    static String[] ab_month_nm = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    static String[] month_nm = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final int LOOP_COUNT = 200000;
    private static ThreadLocal perThreadCalendar = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new GregorianCalendar();
        }
    };

    static int getMonth3Char(String month3Str) {
        for (int i = 0; i < 12; ++i) {
            if (!ab_month_nm[i].equalsIgnoreCase(month3Str)) continue;
            return i;
        }
        return -1;
    }

    static int getMonthFull(String monthNStr, int start) {
        monthNStr = monthNStr.substring(start);
        for (int i = 0; i < 12; ++i) {
            if (!monthNStr.startsWith(month_nm[i])) continue;
            return i;
        }
        return -1;
    }

    static void appendPaddedInt(StringBuffer str, int length, int value) {
        if (length == 4 && value > 2000) {
            str.append(value);
        } else {
            String s = Wrapper.toString(value);
            int actualStrLength = s.length();
            int toPad = length - actualStrLength;
            if (toPad > 0) {
                while (toPad > 0) {
                    str.append('0');
                    --toPad;
                }
            }
            str.append(s);
        }
    }

    public static String formatInternational(Date time) {
        return DateUtils.formatDate(time, INTERNATIONAL_SHORT_DATE_FORMAT);
    }

    public static String formatDate(Date time, String formatStr) {
        StringBuffer p = new StringBuffer(32);
        char[] format = DateUtils.toFormatChars(formatStr);
        int fmtIndex = 0;
        GregorianCalendar calendar = DateUtils.getPerThreadCalendar();
        calendar.setTime(time);
        int tm_year = calendar.get(1);
        int tm_mon = calendar.get(2);
        int tm_mday = calendar.get(5);
        int tm_hour = calendar.get(11);
        int tm_min = calendar.get(12);
        int tm_sec = calendar.get(13);
        int tm_msec = calendar.get(14);
        int length = format.length;
        block9: while (fmtIndex < length) {
            char c = format[fmtIndex++];
            switch (c) {
                case 'y': {
                    int ycount = 1;
                    while (format[fmtIndex] == 'y') {
                        ++ycount;
                        ++fmtIndex;
                    }
                    if (ycount == 4) {
                        if (tm_year >= 10000 || tm_year < 0) {
                            DateUtils.appendPaddedInt(p, 5, tm_year);
                            continue block9;
                        }
                        DateUtils.appendPaddedInt(p, 4, tm_year);
                        continue block9;
                    }
                    DateUtils.appendPaddedInt(p, 2, tm_year % 100);
                    continue block9;
                }
                case 'M': {
                    String r;
                    int mcount = 1;
                    while (format[fmtIndex] == 'M') {
                        ++mcount;
                        ++fmtIndex;
                    }
                    if (mcount <= 2) {
                        DateUtils.appendPaddedInt(p, 2, tm_mon + 1);
                        continue block9;
                    }
                    if (mcount == 3) {
                        r = ab_month_nm[tm_mon];
                        p.append(r);
                        continue block9;
                    }
                    r = month_nm[tm_mon];
                    p.append(r);
                    continue block9;
                }
                case 'd': {
                    int dcount = 1;
                    while (format[fmtIndex] == 'd') {
                        ++dcount;
                        ++fmtIndex;
                    }
                    DateUtils.appendPaddedInt(p, 2, tm_mday);
                    continue block9;
                }
                case 'H': {
                    int hcount = 1;
                    while (format[fmtIndex] == 'H') {
                        ++hcount;
                        ++fmtIndex;
                    }
                    DateUtils.appendPaddedInt(p, 2, tm_hour);
                    continue block9;
                }
                case 'm': {
                    int mcount = 1;
                    while (format[fmtIndex] == 'm') {
                        ++mcount;
                        ++fmtIndex;
                    }
                    DateUtils.appendPaddedInt(p, 2, tm_min);
                    continue block9;
                }
                case 's': {
                    int scount = 1;
                    while (format[fmtIndex] == 's') {
                        ++scount;
                        ++fmtIndex;
                    }
                    DateUtils.appendPaddedInt(p, 2, tm_sec);
                    continue block9;
                }
                case 'S': {
                    int scount = 1;
                    while (format[fmtIndex] == 'S') {
                        ++scount;
                        ++fmtIndex;
                    }
                    DateUtils.appendPaddedInt(p, 3, tm_msec);
                    continue block9;
                }
            }
            if (c == '\u0000') continue;
            p.append(c);
        }
        return p.toString();
    }

    private static char[] toFormatChars(String format) {
        char[] formatChars = new char[format.length() + 1];
        format.getChars(0, format.length(), formatChars, 0);
        formatChars[format.length()] = '\u0000';
        return formatChars;
    }

    boolean ischardigit(char c) {
        return c >= '0' && c <= '9';
    }

    static int toInt(String ptr, int startIndex, int length) throws ParseException {
        try {
            if (ptr.length() - startIndex < length) {
                throw new ParseException("Date parsing error", startIndex);
            }
            String eptr = ptr.substring(startIndex, startIndex + length);
            return Integer.parseInt(eptr);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error parsing date", startIndex);
        }
    }

    public static Date parseDate(String dateStr, String format) throws ParseException {
        return DateUtils.parseDate(dateStr, format, true);
    }

    public static Date parseDate(String dateStr, String formatStr, boolean linient) throws ParseException {
        char[] format = DateUtils.toFormatChars(formatStr);
        int length = formatStr.length() + 1;
        int tm_year = 0;
        int tm_mon = 0;
        int tm_mday = 0;
        int tm_hour = 0;
        int tm_min = 0;
        int tm_sec = 0;
        int tm_msec = 0;
        int fmtIndex = 0;
        int inputIndex = 0;
        block9: while (fmtIndex < length && inputIndex < dateStr.length()) {
            char c = format[fmtIndex++];
            switch (c) {
                case 'y': {
                    int ycount = 1;
                    while (format[fmtIndex] == 'y') {
                        ++ycount;
                        ++fmtIndex;
                    }
                    if (ycount >= 4) {
                        tm_year = DateUtils.toInt(dateStr, inputIndex, 4);
                        inputIndex += 4;
                        break;
                    }
                    if (ycount < 2) {
                        throw new ParseException("Illegal year pattern in '" + formatStr + "'. At least 2 y's expected.", inputIndex);
                    }
                    if (ycount == 3 || ycount > 4) {
                        throw new ParseException("Illegal year pattern in '" + formatStr + "'. Only patterns 'yy' and 'yyyy' are supported.", inputIndex);
                    }
                    int year = DateUtils.toInt(dateStr, inputIndex, 2);
                    year = year < 70 ? (year += 2000) : (year += 1900);
                    tm_year = year;
                    inputIndex += 2;
                    break;
                }
                case 'M': {
                    int month_index;
                    int mcount = 1;
                    while (format[fmtIndex] == 'M') {
                        ++mcount;
                        ++fmtIndex;
                    }
                    if (mcount == 2) {
                        tm_mon = DateUtils.toInt(dateStr, inputIndex, 2) - 1;
                        inputIndex += 2;
                        break;
                    }
                    if (mcount < 2) {
                        throw new ParseException("Illegal month pattern in '" + formatStr + "'. At least 2 M's expected.", inputIndex);
                    }
                    if (mcount == 3) {
                        month_index = DateUtils.getMonth3Char(dateStr.substring(inputIndex, inputIndex + 3));
                        if (month_index == -1) {
                            throw new ParseException("Error parsing month part of date string, expected pattern " + formatStr + " found " + dateStr, inputIndex);
                        }
                        tm_mon = month_index;
                        inputIndex += 3;
                        break;
                    }
                    month_index = DateUtils.getMonthFull(dateStr, inputIndex);
                    if (month_index == -1) {
                        throw new ParseException("Error parsing month part of date string, expected pattern " + formatStr + " found " + dateStr, inputIndex);
                    }
                    tm_mon = month_index;
                    inputIndex += month_nm[month_index].length();
                    break;
                }
                case 'd': {
                    int dcount = 1;
                    while (format[fmtIndex] == 'd') {
                        ++dcount;
                        ++fmtIndex;
                    }
                    if (dcount == 2) {
                        tm_mday = DateUtils.toInt(dateStr, inputIndex, 2);
                        inputIndex += 2;
                        break;
                    }
                    throw new ParseException("Illegal date pattern in '" + formatStr + "'. Only pattern 'dd' is supported.", inputIndex);
                }
                case 'H': {
                    int hcount = 1;
                    while (format[fmtIndex] == 'H') {
                        ++hcount;
                        ++fmtIndex;
                    }
                    if (hcount == 2) {
                        tm_hour = DateUtils.toInt(dateStr, inputIndex, 2);
                        inputIndex += 2;
                        break;
                    }
                    throw new ParseException("Illegal hour pattern in '" + formatStr + "'. Only pattern 'HH' is supported.", inputIndex);
                }
                case 'm': {
                    int mcount = 1;
                    while (format[fmtIndex] == 'm') {
                        ++mcount;
                        ++fmtIndex;
                    }
                    if (mcount == 2) {
                        tm_min = DateUtils.toInt(dateStr, inputIndex, 2);
                        inputIndex += 2;
                        break;
                    }
                    throw new ParseException("Illegal minute pattern in '" + formatStr + "'. Only pattern 'mm' is supported.", inputIndex);
                }
                case 's': {
                    int scount = 1;
                    while (format[fmtIndex] == 's') {
                        ++scount;
                        ++fmtIndex;
                    }
                    if (scount == 2) {
                        tm_sec = DateUtils.toInt(dateStr, inputIndex, 2);
                        inputIndex += 2;
                        break;
                    }
                    throw new IllegalArgumentException("Illegal seconds pattern in '" + formatStr + "'. Only pattern 'ss' is supported.");
                }
                case 'S': {
                    int scount = 1;
                    while (format[fmtIndex] == 'S') {
                        ++scount;
                        ++fmtIndex;
                    }
                    if (scount > 3) {
                        throw new ParseException("Illegal milli-seconds pattern in '" + formatStr + "'. Only pattern 'SSS' is supported.", inputIndex);
                    }
                    tm_msec = DateUtils.toInt(dateStr, inputIndex, 3);
                    inputIndex += 3;
                    break;
                }
                default: {
                    if (c == '\u0000') continue block9;
                    if (c == dateStr.charAt(inputIndex)) {
                        ++inputIndex;
                        break;
                    }
                    if (linient) continue block9;
                    throw new ParseException("Error parsing date string, expected pattern '" + formatStr + "' found '" + dateStr + "'", inputIndex);
                }
            }
        }
        if (inputIndex != dateStr.length() && !linient) {
            throw new ParseException("Additional characters at the end of date string, expected pattern '" + formatStr + "' found '" + dateStr + "'", inputIndex);
        }
        GregorianCalendar calendar = DateUtils.getPerThreadCalendar();
        calendar.set(tm_year, tm_mon, tm_mday, tm_hour, tm_min, tm_sec);
        calendar.set(14, tm_msec);
        return calendar.getTime();
    }

    public static void cmtmain(String[] args) throws ParseException, InterruptedException {
        Date dt = new Date(105, 1, 10, 7, 30, 45);
        String str = DateUtils.formatDate(new Date(), "yyyyMMdd HH:mm:ss.SSS");
        System.out.println(str);
        System.out.println(DateUtils.formatDate(new Date(), "yyyy-MMM-dd HH:mm:ss.SSS"));
        Date ret = DateUtils.parseDate(str, "yyyyMMdd HH:mm:ss.SSSA", true);
        System.out.println(ret);
        ret = DateUtils.parseDate("Oct 11 2007", "MMM dd yyyy");
        System.out.println(ret);
        DateUtils.prefTestSDF("2007-10-04 12:32:43.100", "yyyy-MM-dd HH:mm:ss.SSS");
        DateUtils.prefTest("2007-10-04 12:32:43.100", "yyyy-MM-dd HH:mm:ss.SSS");
        Date now = new Date();
        DateUtils.prefTestFormatSDF(now, "yyyy-MM-dd HH:mm:ss.SSS");
        DateUtils.prefFormatTest(now, "yyyy-MM-dd HH:mm:ss.SSS");
        Thread.sleep(500L);
        System.out.println("PREF TESTING ------------");
        System.gc();
        DateUtils.prefTestSDF("2007-10-04 12:32:43.100", "yyyy-MM-dd HH:mm:ss.SSS");
        Thread.sleep(500L);
        DateUtils.prefTestFormatSDF(now, "yyyy-MM-dd HH:mm:ss.SSS");
        System.gc();
        DateUtils.prefTest("2007-10-04 12:32:43.100", "yyyy-MM-dd HH:mm:ss.SSS");
        Thread.sleep(500L);
        DateUtils.prefFormatTest(now, "yyyy-MM-dd HH:mm:ss.SSS");
        Thread.sleep(500L);
    }

    static void prefTestSDF(String date, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 200000; ++i) {
            sdf.parse(date);
        }
        long end = System.currentTimeMillis();
        System.out.println("Time SDF= " + (end - start) + "ms");
    }

    static void prefTest(String date, String format) throws ParseException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 200000; ++i) {
            DateUtils.parseDate(date, format);
        }
        long end = System.currentTimeMillis();
        System.out.println("Time Volante= " + (end - start) + "ms");
    }

    static void prefTestFormatSDF(Date date, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 200000; ++i) {
            sdf.format(date);
        }
        long end = System.currentTimeMillis();
        System.out.println("Time SDF Format= " + (end - start) + "ms");
    }

    static void prefFormatTest(Date date, String format) throws ParseException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 200000; ++i) {
            DateUtils.formatDate(date, format);
        }
        long end = System.currentTimeMillis();
        System.out.println("Time Volante Format= " + (end - start) + "ms");
    }

    private static GregorianCalendar getPerThreadCalendar() {
        return (GregorianCalendar)perThreadCalendar.get();
    }

    public static String yyyymmddToShortDisplayDate(String yyyymmdd) {
        try {
            SimpleDateFormat yyyymmddFormat = new SimpleDateFormat("yyyyMMdd");
            Date date = yyyymmddFormat.parse(yyyymmdd);
            SimpleDateFormat shotForm = new SimpleDateFormat(INTERNATIONAL_SHORT_DATE_FORMAT);
            return shotForm.format(date);
        }
        catch (ParseException e) {
            return yyyymmdd;
        }
    }

    public static Date getDatePart(Date dateObj) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dateObj);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int date = calendar.get(5);
        calendar.clear();
        calendar.set(year, month, date);
        return calendar.getTime();
    }

    public static int daysBetween(Date date1, Date date2) {
        if (date1.compareTo(date2) == 0) {
            return 0;
        }
        int differenceInDays = (int)((date1.getTime() - date2.getTime()) / (long)milliSecInDays);
        return differenceInDays;
    }
}

