/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.lang.Shutdown;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;

public class DeleteOnExitHook
implements Runnable {
    protected static Log log = LogFactory.getLog(DeleteOnExitHook.class);
    private static DeleteOnExitHook instance = null;
    private final LinkedHashSet files = new LinkedHashSet();

    private static synchronized DeleteOnExitHook hook() {
        if (instance == null) {
            instance = new DeleteOnExitHook();
            Shutdown.add(instance);
        }
        return instance;
    }

    private DeleteOnExitHook() {
    }

    public static void add(String file) {
        DeleteOnExitHook.hook().files.add(file);
    }

    public void run() {
        ArrayList toBeDeleted = new ArrayList(this.files);
        Collections.reverse(toBeDeleted);
        for (int i = 0; i < toBeDeleted.size(); ++i) {
            String fileName = (String)toBeDeleted.get(i);
            File file = new File(fileName);
            log.info("Deleting " + fileName);
            if (file.isDirectory()) {
                IOUtil.delDir(file);
                continue;
            }
            file.delete();
        }
    }
}

