/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.IConfigurationImpl;
import com.tplus.transform.util.ISection;
import com.tplus.transform.util.KeyValueException;
import com.tplus.transform.util.SequencedHashMap;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;

public class ISectionImpl
implements ISection {
    private IConfigurationImpl config;
    private String name;
    private Map keyValues;

    public ISectionImpl(String name, IConfigurationImpl config) {
        this.name = name;
        this.keyValues = Collections.synchronizedMap(new SequencedHashMap());
        this.config = config;
    }

    public String getSectionName() {
        return this.name;
    }

    public String getKeyValue(String key) {
        Object value = this.keyValues.get(key);
        return (String)value;
    }

    public synchronized String getKeyValue(String key, String defaultValue) {
        Object value = this.keyValues.get(key);
        if (value != null) {
            return (String)value;
        }
        return defaultValue;
    }

    public synchronized int getKeyIntValue(String key, int defaultValue) {
        try {
            return this.getKeyIntValue(key);
        }
        catch (KeyValueException e) {
            return defaultValue;
        }
    }

    public synchronized int getKeyIntValue(String key) throws KeyValueException {
        String value = this.getKeyValue(key);
        if (value != null) {
            try {
                int val = Integer.parseInt(value);
                return val;
            }
            catch (NumberFormatException e) {
                throw new KeyValueException(value + " not an number");
            }
        }
        throw new KeyValueException(key + " - Key not found");
    }

    public synchronized long getKeyLongValue(String key, long defaultValue) {
        try {
            return this.getKeyLongValue(key);
        }
        catch (KeyValueException e) {
            return defaultValue;
        }
    }

    public synchronized long getKeyLongValue(String key) throws KeyValueException {
        String value = this.getKeyValue(key);
        if (value != null) {
            try {
                long val = Long.parseLong(value);
                return val;
            }
            catch (NumberFormatException e) {
                throw new KeyValueException(value + " not an number");
            }
        }
        throw new KeyValueException(key + " - Key not found");
    }

    public boolean getKeyBoolValue(String key, boolean defaultValue) {
        try {
            return this.getKeyBoolValue(key);
        }
        catch (KeyValueException e) {
            return defaultValue;
        }
    }

    public boolean getKeyBoolValue(String key) throws KeyValueException {
        boolean toret = false;
        String value = this.getKeyValue(key);
        if (value != null) {
            toret = ISectionImpl.stringToBool(value);
            return toret;
        }
        throw new KeyValueException(key + " - Key not found");
    }

    public synchronized void addKeyValue(String key, String val) {
        this.keyValues.put(key, val);
        this.config.setModified(true);
    }

    public synchronized void addKeyIntValue(String key, int value) {
        this.keyValues.put(key, String.valueOf(value));
        this.config.setModified(true);
    }

    public synchronized void addKeyBoolValue(String key, boolean val) {
        this.keyValues.put(key, val ? "true" : "false");
        this.config.setModified(true);
    }

    public synchronized boolean removeKeyValue(String key) {
        Object value = this.keyValues.remove(key);
        if (value != null) {
            this.config.setModified(true);
        }
        return value != null;
    }

    public synchronized void removeAllKeys() {
        this.keyValues.clear();
        this.config.setModified(true);
    }

    public synchronized int getCount() {
        return this.keyValues.size();
    }

    public synchronized String[] getKeys() {
        String[] keys = new String[this.keyValues.size()];
        this.keyValues.keySet().toArray(keys);
        return keys;
    }

    public synchronized String[] getValues() {
        String[] values = new String[this.keyValues.size()];
        this.keyValues.values().toArray(values);
        return values;
    }

    private static boolean stringToBool(String str) throws KeyValueException {
        if (str.equalsIgnoreCase("true") || str.equals("1")) {
            return true;
        }
        if (str.equalsIgnoreCase("false") || str.equals("0")) {
            return false;
        }
        throw new KeyValueException(str + " not a boolean value");
    }

    synchronized void write(PrintWriter ps) {
        for (Map.Entry entry : this.keyValues.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value != null) {
                ps.println(key + "=" + value);
                continue;
            }
            ps.println(key + "=");
        }
    }
}

