/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapUtils {
    public static Number toNumber(Object answer) {
        if (answer != null) {
            if (answer instanceof Number) {
                return (Number)answer;
            }
            if (answer instanceof String) {
                try {
                    String text = (String)answer;
                    return NumberFormat.getInstance().parse(text);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Boolean toBoolean(Object answer) {
        if (answer != null) {
            if (answer instanceof Boolean) {
                return (Boolean)answer;
            }
            if (answer instanceof String) {
                return Boolean.valueOf((String)answer);
            }
            if (answer instanceof Number) {
                Number n = (Number)answer;
                return n.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public static Map mapWithKeysAndValues(Class mapClass, Object[] keys, Object[] values) {
        List<Object> keyCollection = keys != null ? Arrays.asList(keys) : Collections.EMPTY_LIST;
        List<Object> valuesCollection = values != null ? Arrays.asList(values) : Collections.EMPTY_LIST;
        return MapUtils.mapWithKeysAndValues(mapClass, keyCollection.iterator(), valuesCollection.iterator());
    }

    public static Map mapWithKeysAndValues(Class mapClass, Collection keys, Collection values) {
        keys = keys != null ? keys : Collections.EMPTY_LIST;
        values = values != null ? values : Collections.EMPTY_LIST;
        return MapUtils.mapWithKeysAndValues(mapClass, keys.iterator(), values.iterator());
    }

    public static Map mapWithKeysAndValues(Class mapClass, Iterator keys, Iterator values) {
        Map m = null;
        if (mapClass == null) {
            throw new IllegalArgumentException("Map class must not be null!");
        }
        try {
            m = (Map)mapClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (keys != null && values != null) {
            while (keys.hasNext() && values.hasNext()) {
                m.put(keys.next(), values.next());
            }
        }
        return m;
    }
}

