/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.io.SafeFile;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.POMInfo;
import com.tplus.transform.util.xml.XMLUtils;
import com.tplus.transform.util.xml.XMLWriterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class POMUtil {
    public static final String ARTIFACT_ID = "artifactId";
    public static final String GROUP_ID = "groupId";
    public static final String VERSION = "version";
    public static final String PACKAGING = "packaging";
    public static final String DESCRIPTION = "description";
    public static final String DEPENDENCY = "dependency";
    public static final String POM_XML_FILE = "pom.xml";
    public static final String PROJECT = "project";

    public static POMInfo readPOM(URL url) throws IOException, SAXException, ParserConfigurationException {
        InputStream inputStream = url.openConnection().getInputStream();
        if (inputStream != null) {
            return POMUtil.readPOM(inputStream);
        }
        return null;
    }

    private static POMInfo readPOM(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        POMInfo info = new POMInfo();
        Document document = XMLUtils.createDocument(inputStream);
        Element documentElement = document.getDocumentElement();
        String groupId = XMLUtils.getSingleChildElementValue(documentElement, GROUP_ID);
        String artifactId = XMLUtils.getSingleChildElementValue(documentElement, ARTIFACT_ID);
        String version = XMLUtils.getSingleChildElementValue(documentElement, VERSION);
        info.setGroupId(groupId);
        info.setArtifactId(artifactId);
        info.setVersion(version);
        info.setPackaging(XMLUtils.getSingleChildElementValue(documentElement, PACKAGING));
        info.setClassifier(XMLUtils.getSingleChildElementValue(documentElement, "classifier"));
        info.setDescription(XMLUtils.getSingleChildElementValue(documentElement, DESCRIPTION));
        NodeList dependencies = XMLUtils.getChildElementsByTagName(documentElement, DEPENDENCY);
        for (int i = 0; i < dependencies.getLength(); ++i) {
            Element item = (Element)dependencies.item(i);
            String groupId2 = XMLUtils.getSingleChildElementValue(item, GROUP_ID);
            String artifactId2 = XMLUtils.getSingleChildElementValue(item, ARTIFACT_ID);
            String version2 = XMLUtils.getSingleChildElementValue(item, VERSION);
            POMInfo dependency = new POMInfo();
            dependency.setGroupId(groupId2);
            dependency.setArtifactId(artifactId2);
            dependency.setVersion(version2);
            info.getDependencies().add(dependency);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static POMInfo readPOMFromJar(String fileName) {
        if (!new File(fileName).exists()) return null;
        try {
            SafeFile.doFileCheck(fileName);
            ZipInputStream zin = new ZipInputStream(new FileInputStream(fileName));
            try {
                ZipEntry zipEntry = null;
                while ((zipEntry = zin.getNextEntry()) != null) {
                    String entryName = zipEntry.getName();
                    if (!entryName.endsWith(POM_XML_FILE)) continue;
                    POMInfo pOMInfo = POMUtil.readPOM(zin);
                    return pOMInfo;
                }
            }
            catch (SAXException e) {
                e.printStackTrace();
                return null;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                return null;
            }
            finally {
                zin.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean extractPOMFromJar(String fileName, String outputFile) {
        if (!new File(fileName).exists()) return false;
        try {
            SafeFile.doFileCheck(fileName);
            ZipInputStream zin = new ZipInputStream(new FileInputStream(fileName));
            try {
                ZipEntry zipEntry = null;
                while ((zipEntry = zin.getNextEntry()) != null) {
                    String entryName = zipEntry.getName();
                    if (!entryName.endsWith(POM_XML_FILE)) continue;
                    IOUtil.copyStreams(zin, new FileOutputStream(outputFile), true);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                zin.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void main(String[] args) {
        POMUtil.extractPOMFromJar(args[0], args[1]);
    }

    public static void createPOMFile(POMInfo pomInfo, String pomName) throws IOException {
        XMLWriterUtil xmlWriterUtil = new XMLWriterUtil();
        StringBuffer toRet = new StringBuffer();
        toRet.append(xmlWriterUtil.startTag(PROJECT));
        toRet.append(xmlWriterUtil.tagValue("modelVersion", "4.0.0"));
        toRet.append(xmlWriterUtil.tagValue(GROUP_ID, pomInfo.getGroupId()));
        toRet.append(xmlWriterUtil.tagValue(ARTIFACT_ID, pomInfo.getArtifactId()));
        toRet.append(xmlWriterUtil.tagValue(VERSION, pomInfo.getVersion()));
        toRet.append(xmlWriterUtil.tagValue(DESCRIPTION, pomInfo.getDescription()));
        toRet.append(xmlWriterUtil.tagValue(PACKAGING, pomInfo.getPackaging()));
        toRet.append(xmlWriterUtil.endTag(PROJECT));
        IOUtil.write(pomName, toRet.toString());
    }
}

