/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Version
implements Serializable,
Cloneable,
Comparable {
    public static final String VERSION_NUMBER_SEPARATOR = ".";
    String versionStr;
    transient String canonicalVersionStr;

    public Version(String versionStr) {
        if (versionStr == null) {
            versionStr = "";
        }
        this.versionStr = versionStr;
    }

    public Version(String versionStr, boolean canonicalVersion) {
        this.versionStr = canonicalVersion ? Version.uncanonicalizeVersion(versionStr) : versionStr;
    }

    public int getBranchIndexOf(Version base) {
        String numberPart;
        if (this.versionStr.startsWith(base.versionStr) && this.versionStr.length() > base.versionStr.length() && (numberPart = this.versionStr.substring(base.versionStr.length() + 1)).indexOf(46) == -1) {
            int subNumber = Integer.parseInt(numberPart);
            return subNumber;
        }
        return 0;
    }

    public int compareTo(Object o) {
        Version other = (Version)o;
        return this.getCanonicalVersion().compareTo(other.getCanonicalVersion());
    }

    public boolean equals(Object o) {
        if (o instanceof Version) {
            Version other = (Version)o;
            return this.versionStr.equals(other.versionStr);
        }
        return false;
    }

    public String getCanonicalVersion() {
        if (this.canonicalVersionStr == null) {
            this.canonicalVersionStr = this.prepareCanonicalVersion();
        }
        return this.canonicalVersionStr;
    }

    private String prepareCanonicalVersion() {
        StringBuffer canonicalVersion = new StringBuffer();
        int[] versionNumbers = Version.getVersionNumbers(this.versionStr);
        for (int i = 0; i < versionNumbers.length; ++i) {
            if (i != 0) {
                canonicalVersion.append(VERSION_NUMBER_SEPARATOR);
            }
            if (versionNumbers[i] < 10) {
                canonicalVersion.append("0");
            }
            canonicalVersion.append(versionNumbers[i]);
        }
        return canonicalVersion.toString();
    }

    private static String uncanonicalizeVersion(String canonicalVersion) {
        StringBuffer displayVersion = new StringBuffer();
        int[] versionNumbers = Version.getVersionNumbers(canonicalVersion);
        for (int i = 0; i < versionNumbers.length; ++i) {
            if (i != 0) {
                displayVersion.append(VERSION_NUMBER_SEPARATOR);
            }
            displayVersion.append(versionNumbers[i]);
        }
        return displayVersion.toString();
    }

    public String toString() {
        return this.versionStr;
    }

    private static int[] getVersionNumbers(String canonicalVersion) {
        StringTokenizer st = new StringTokenizer(canonicalVersion, VERSION_NUMBER_SEPARATOR);
        int[] versionNumbers = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            versionNumbers[i] = Integer.parseInt(token);
            ++i;
        }
        return versionNumbers;
    }

    public Version getNextMajorVersion() {
        return new Version(Integer.toString(this.getMajorVersion() + 1));
    }

    public Version getNextMinorVersion() {
        return new Version(Integer.toString(this.getMajorVersion()) + VERSION_NUMBER_SEPARATOR + (this.getMinorVersion() + 1));
    }

    public Version getNextMicroVersion() {
        return new Version(Integer.toString(this.getMajorVersion()) + VERSION_NUMBER_SEPARATOR + this.getMinorVersion() + VERSION_NUMBER_SEPARATOR + (this.getMicroVersion() + 1));
    }

    public int getMajorVersion() {
        List tokens = Version.getVersionTokens(this.versionStr);
        String majorVersionStr = (String)tokens.get(0);
        int majorVersion = Integer.parseInt(majorVersionStr);
        return majorVersion;
    }

    public int getMinorVersion() {
        List tokens = Version.getVersionTokens(this.versionStr);
        if (tokens.size() > 1) {
            String minorVersionStr = (String)tokens.get(1);
            int minorVersion = Integer.parseInt(minorVersionStr);
            return minorVersion;
        }
        return 0;
    }

    public int getMicroVersion() {
        List tokens = Version.getVersionTokens(this.versionStr);
        if (tokens.size() > 2) {
            String microVersionStr = (String)tokens.get(2);
            int microVersion = Integer.parseInt(microVersionStr);
            return microVersion;
        }
        return 0;
    }

    public boolean isMajorVersion() {
        List tokens = Version.getVersionTokens(this.versionStr);
        return tokens.size() == 1;
    }

    public int compareTo(Version info, boolean withPatch) {
        int thatMinorVersion;
        int thatMajorVersion;
        int thisMajorVersion = this.getMajorVersion();
        if (thisMajorVersion != (thatMajorVersion = info.getMajorVersion())) {
            return thisMajorVersion - thatMajorVersion;
        }
        int thisMinorVersion = this.getMinorVersion();
        if (thisMinorVersion != (thatMinorVersion = info.getMinorVersion())) {
            return thisMinorVersion - thatMinorVersion;
        }
        if (withPatch) {
            return this.getMicroVersion() - info.getMicroVersion();
        }
        return 0;
    }

    public void validate() {
        if (this.versionStr.equals("")) {
            throw new RuntimeException("Version cannot be empty");
        }
        List versionTokens = Version.getVersionTokens(this.versionStr);
        for (int i = 0; i < versionTokens.size(); ++i) {
            String token = (String)versionTokens.get(i);
            if (token.length() == 0) {
                throw new RuntimeException("Version number cannot be empty.");
            }
            if (!Version.isDigit(token)) {
                throw new RuntimeException("Version number cannot have characters other than digits.");
            }
            if (token.length() <= 2) continue;
            throw new RuntimeException("Version number cannot have more than two digits.");
        }
    }

    static List getVersionTokens(String version) {
        ArrayList<String> versionTokens = new ArrayList<String>();
        String temp = version;
        int index = temp.indexOf(VERSION_NUMBER_SEPARATOR);
        while (index != -1) {
            versionTokens.add(temp.substring(0, index));
            temp = temp.substring(index + 1);
            index = temp.indexOf(VERSION_NUMBER_SEPARATOR);
        }
        versionTokens.add(temp);
        return versionTokens;
    }

    static boolean isDigit(String token) {
        for (int i = 0; i < token.length(); ++i) {
            if (Character.isDigit(token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Version createVersion(String version) {
        if (version != null && version.length() > 0) {
            return new Version(version);
        }
        return null;
    }
}

