/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.bean;

import com.tplus.transform.util.bean.BeanIntrospector;
import com.tplus.transform.util.bean.IntrospectionContext;
import com.tplus.transform.util.bean.MethodUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;

public class DefaultBeanIntrospector
implements BeanIntrospector {
    public static final BeanIntrospector INSTANCE = new DefaultBeanIntrospector();
    private static final Class[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Class[] LIST_CLASS_PARAMETER = new Class[]{List.class};
    protected static Log log = LogFactory.getLog(DefaultBeanIntrospector.class);

    private DefaultBeanIntrospector() {
    }

    public void introspect(IntrospectionContext icontext) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(icontext.getTargetClass());
        }
        catch (IntrospectionException e) {
            log.error("Error when inspecting class " + icontext.getTargetClass(), e);
            return;
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        this.handleIndexedPropertyDescriptors(icontext.getTargetClass(), descriptors);
        icontext.addPropertyDescriptors(descriptors);
    }

    private void handleIndexedPropertyDescriptors(Class beanClass, PropertyDescriptor[] descriptors) {
        for (int i = 0; i < descriptors.length; ++i) {
            String methodName;
            Method readMethod;
            PropertyDescriptor pd = descriptors[i];
            if (!(pd instanceof IndexedPropertyDescriptor)) continue;
            IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)pd;
            String propName = descriptor.getName().substring(0, 1).toUpperCase() + descriptor.getName().substring(1);
            if (descriptor.getReadMethod() == null && (readMethod = MethodUtils.getMatchingAccessibleMethod(beanClass, methodName = descriptor.getIndexedReadMethod() != null ? descriptor.getIndexedReadMethod().getName() : "get" + propName, EMPTY_CLASS_PARAMETERS)) != null) {
                try {
                    descriptor.setReadMethod(readMethod);
                }
                catch (Exception e) {
                    log.error("Error setting indexed property read method", e);
                }
            }
            if (descriptor.getWriteMethod() != null) continue;
            methodName = descriptor.getIndexedWriteMethod() != null ? descriptor.getIndexedWriteMethod().getName() : "set" + propName;
            Method writeMethod = MethodUtils.getMatchingAccessibleMethod(beanClass, methodName, LIST_CLASS_PARAMETER);
            if (writeMethod == null) {
                Method[] methods = beanClass.getMethods();
                for (int i1 = 0; i1 < methods.length; ++i1) {
                    Class<?>[] parameterTypes;
                    Method m = methods[i1];
                    if (!m.getName().equals(methodName) || (parameterTypes = m.getParameterTypes()).length != 1 || !List.class.isAssignableFrom(parameterTypes[0])) continue;
                    writeMethod = m;
                    break;
                }
            }
            if (writeMethod == null) continue;
            try {
                descriptor.setWriteMethod(writeMethod);
                continue;
            }
            catch (Exception e) {
                log.error("Error setting indexed property write method", e);
            }
        }
    }
}

