/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

class DiffState {
    public static final int Matched = 1;
    public static final int NoMatch = -1;
    public static final int Unknown = -2;
    private static final int BAD_INDEX = -1;
    private int startIndex;
    private int length;

    public DiffState() {
        this.setToUnknown();
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.startIndex + this.length - 1;
    }

    public int getLength() {
        int len = this.length > 0 ? this.length : (this.length == 0 ? 1 : 0);
        return len;
    }

    public int getStatus() {
        int stat;
        if (this.length > 0) {
            stat = 1;
        } else {
            switch (this.length) {
                case -1: {
                    stat = -1;
                    break;
                }
                default: {
                    stat = -2;
                }
            }
        }
        return stat;
    }

    protected void setToUnknown() {
        this.startIndex = -1;
        this.length = -2;
    }

    public void setMatch(int start, int length) {
        this.startIndex = start;
        this.length = length;
    }

    public void setNoMatch() {
        this.startIndex = -1;
        this.length = -1;
    }

    public boolean hasValidLength(int newStart, int newEnd, int maxPossibleDestLength) {
        if (this.length > 0 && (maxPossibleDestLength < this.length || this.startIndex < newStart || this.getEndIndex() > newEnd)) {
            this.setToUnknown();
        }
        return this.length != -2;
    }
}

