/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.diff.CharData;
import com.tplus.transform.util.diff.DiffEngine;
import com.tplus.transform.util.diff.DiffOptions;
import com.tplus.transform.util.diff.DiffResultSpan;
import com.tplus.transform.util.diff.EncodingDetector;
import com.tplus.transform.util.diff.EqualsElementComparator;
import com.tplus.transform.util.diff.IDiffList;
import com.tplus.transform.util.diff.MaskedText;
import com.tplus.transform.util.diff.TextFile;
import com.tplus.transform.util.diff.TextLine;
import com.tplus.transform.util.diff.TextLineElementComparator;
import com.tplus.transform.util.xml.XMLWriterUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DiffUtil {
    private static final int MASK = 8;
    static boolean useWords;
    static String style;

    static void applyMask(List diffReport, MaskedText srcMask, MaskedText destMask) {
        for (int i = 0; i < diffReport.size(); ++i) {
            DiffResultSpan span = (DiffResultSpan)diffReport.get(i);
            int status = span.getStatus();
            int newSrcLine = span.getSourceIndex();
            int newDestLine = span.getDestIndex();
            if (newSrcLine != -1) {
                int oldSourceIndex = srcMask.mapNewLineToOld(newSrcLine);
                span.setSourceIndex(oldSourceIndex);
            }
            if (newDestLine != -1) {
                int oldDestIndex = destMask.mapNewLineToOld(newDestLine);
                span.setDestIndex(oldDestIndex);
            }
            if (status != 1) continue;
            List linesReports = (List)span.getUserObject();
            for (int j = 0; j < linesReports.size(); ++j) {
                List lineReport = (List)linesReports.get(j);
                for (int k = 0; k < lineReport.size(); ++k) {
                    DiffResultSpan subSpan = (DiffResultSpan)lineReport.get(k);
                    int oldSourceColumnIndex = srcMask.mapNewColumnToOld(newSrcLine + j, subSpan.getSourceIndex());
                    int oldDestColumnIndex = destMask.mapNewColumnToOld(newDestLine + j, subSpan.getDestIndex());
                    subSpan.setSourceIndex(oldSourceColumnIndex);
                    subSpan.setDestIndex(oldDestColumnIndex);
                }
            }
        }
    }

    public static List diffFiles(TextFile textFile1, TextFile textFile2, DiffOptions diffOptions) {
        List diffReport;
        if (diffOptions != null && diffOptions.hasSetting()) {
            MaskedText srcMaskedText = new MaskedText(textFile1.getContent());
            srcMaskedText.mask(diffOptions);
            MaskedText destMaskedText = new MaskedText(textFile2.getContent());
            destMaskedText.mask(diffOptions);
            TextFile maskedTextFile1 = new TextFile(srcMaskedText.getMaskedText(), true);
            TextFile maskedTextFile2 = new TextFile(destMaskedText.getMaskedText(), true);
            diffReport = DiffUtil.diffFiles(maskedTextFile1, maskedTextFile2);
            DiffUtil.applyMask(diffReport, srcMaskedText, destMaskedText);
        } else {
            diffReport = DiffUtil.diffFiles(textFile1, textFile2);
        }
        return diffReport;
    }

    public static List diffFiles(TextFile textFile1, TextFile textFile2) {
        DiffEngine diffEngine = new DiffEngine();
        TextLineElementComparator comparator = new TextLineElementComparator();
        comparator.setIgnoreWhitespace(true);
        diffEngine.processDiff(textFile1, textFile2, comparator);
        List diffReport = diffEngine.DiffReport();
        block5: for (int i = 0; i < diffReport.size(); ++i) {
            DiffResultSpan span = (DiffResultSpan)diffReport.get(i);
            int sourceIndex = span.getSourceIndex();
            int destIndex = span.getDestIndex();
            int length = span.getLength();
            switch (span.getStatus()) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    ArrayList<List> detailedReports = new ArrayList<List>();
                    for (int j = 0; j < length; ++j) {
                        TextLine line1 = (TextLine)textFile1.get(sourceIndex + j);
                        TextLine line2 = (TextLine)textFile2.get(destIndex + j);
                        List detailedReport = DiffUtil.detailedLineReport(line1, line2);
                        detailedReports.add(detailedReport);
                    }
                    span.setUserObject(detailedReports);
                    continue block5;
                }
                case 2: {
                    continue block5;
                }
            }
        }
        return diffReport;
    }

    static List detailedLineReport(TextLine line1, TextLine line2) {
        IDiffList destination;
        IDiffList source;
        DiffEngine diffEngine = new DiffEngine();
        if (useWords) {
            source = line1.getWordData();
            destination = line2.getWordData();
        } else {
            source = new CharData(line1.getLine());
            destination = new CharData(line2.getLine());
        }
        diffEngine.processDiff(source, destination, new EqualsElementComparator());
        List report = diffEngine.DiffReport();
        return report;
    }

    public static void diffFiles(String file1, String file2, String outputFile) throws IOException {
        DiffUtil.diffFiles(file1, file2, null, outputFile);
    }

    public static void diffFiles(String file1, String file2, DiffOptions diffOptions, String outputFile) throws IOException {
        TextFile textFile1 = new TextFile(file1);
        TextFile textFile2 = new TextFile(file2);
        List list = DiffUtil.diffFiles(textFile1, textFile2, diffOptions);
        HTMLReportGenerator htmlReportGenerator = new HTMLReportGenerator(textFile1, textFile2);
        if (outputFile == null) {
            outputFile = file1 + "-Diff.html";
        }
        String title = DiffUtil.computeTitle(file1, file2);
        htmlReportGenerator.prepareHTMLReport(list, outputFile, title);
    }

    private static String computeTitle(String file1, String file2) {
        if (file1 != null && file2 != null) {
            return new File(file1).getName() + " vs " + new File(file2).getName();
        }
        return file1;
    }

    public static String diffStringReport(String str1, String str2) {
        TextFile textFile1 = new TextFile(str1, true);
        TextFile textFile2 = new TextFile(str2, true);
        List diffReport = DiffUtil.diffFiles(textFile1, textFile2);
        return DiffUtil.prepareHTMLReport(textFile1, textFile2, diffReport, null);
    }

    public static boolean equalsFiles(String file1, String file2, DiffOptions diffOptions) throws IOException {
        String encoding = DiffUtil.detectEncoding(file1, diffOptions.getDefaultEncoding(), diffOptions.getAutoDetectEncoding());
        return DiffUtil.equalsFiles(file1, file2, diffOptions, encoding, encoding);
    }

    public static boolean equalsFiles(String file1, String file2, DiffOptions diffOptions, String encoding1, String encoding2) throws IOException {
        MaskedText srcMaskedText = new MaskedText(IOUtil.readFileAsString(file1, encoding1));
        srcMaskedText.mask(diffOptions);
        MaskedText destMaskedText = new MaskedText(IOUtil.readFileAsString(file2, encoding2));
        destMaskedText.mask(diffOptions);
        TextFile textFile1 = new TextFile(srcMaskedText.getMaskedText(), true);
        TextFile textFile2 = new TextFile(destMaskedText.getMaskedText(), true);
        List diffReport = DiffUtil.diffFiles(textFile1, textFile2);
        DiffUtil.applyMask(diffReport, srcMaskedText, destMaskedText);
        int diffCount = DiffUtil.getDiffCount(diffReport);
        return diffCount == 0;
    }

    public static String detectEncoding(String file1, String defaultEncoding, Boolean autoDetectEncoding) {
        return EncodingDetector.detectEncoding(file1, defaultEncoding, autoDetectEncoding);
    }

    public static String diffString(String str1, String str2, DiffOptions diffOptions) {
        List diffReport = DiffUtil.diffFiles(new TextFile(str1, true), new TextFile(str2, true), diffOptions);
        int diffCount = DiffUtil.getDiffCount(diffReport);
        if (diffCount > 0) {
            TextFile textFile1 = new TextFile(str1, true);
            TextFile textFile2 = new TextFile(str2, true);
            return DiffUtil.prepareHTMLReport(textFile1, textFile2, diffReport, null);
        }
        return null;
    }

    public static String diffString(String str1, String str2) {
        TextFile textFile1 = new TextFile(str1, true);
        TextFile textFile2 = new TextFile(str2, true);
        List diffReport = DiffUtil.diffFiles(textFile1, textFile2);
        int diffCount = DiffUtil.getDiffCount(diffReport);
        if (diffCount > 0) {
            return DiffUtil.prepareHTMLReport(textFile1, textFile2, diffReport, null);
        }
        return null;
    }

    public static int[] getDiffChangesCount(List diffReport) {
        int modifiedCount = 0;
        int deletedCount = 0;
        int addedCount = 0;
        for (int i = 0; i < diffReport.size(); ++i) {
            DiffResultSpan span = (DiffResultSpan)diffReport.get(i);
            int status = span.getStatus();
            if (status == 2) {
                ++deletedCount;
                continue;
            }
            if (status == 1) {
                ++modifiedCount;
                continue;
            }
            if (status != 3) continue;
            ++addedCount;
        }
        return new int[]{deletedCount, addedCount, modifiedCount};
    }

    public static int getDiffCount(List diffReport) {
        int count = 0;
        for (int i = 0; i < diffReport.size(); ++i) {
            DiffResultSpan span = (DiffResultSpan)diffReport.get(i);
            if (span.getStatus() == 0) continue;
            ++count;
        }
        return count;
    }

    public static String prepareHTMLReport(TextFile textFile1, TextFile textFile2, List diffReport) {
        String title = DiffUtil.computeTitle(textFile1.getFileName(), textFile2.getFileName());
        return DiffUtil.prepareHTMLReport(textFile1, textFile2, diffReport, title);
    }

    public static String prepareHTMLReport(TextFile textFile1, TextFile textFile2, List diffReport, String title) {
        HTMLReportGenerator htmlReportGenerator = new HTMLReportGenerator(textFile1, textFile2);
        String s = htmlReportGenerator.prepareHTMLReportAsText(diffReport, title);
        return s;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Syntax: diff file1 file2");
            System.exit(-1);
        }
        DiffOptions diffOptions = new DiffOptions();
        diffOptions.setIgnoreWhiteSpace(null);
        diffOptions.setIgnoreCharacterCase(false);
        diffOptions.addMaskExpression("ABCDEF", false);
        String s = DiffUtil.diffString(IOUtil.readFileAsString(args[0]), IOUtil.readFileAsString(args[1]), diffOptions);
        if (s != null) {
            String reportFile = new File(new File(args[0]).getParentFile(), "diff.html").getAbsolutePath();
            IOUtil.write(reportFile, s);
        }
    }

    public static void main2(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Syntax: diff file1 file2");
            System.exit(-1);
        }
        DiffUtil.diffFiles(args[0], args[1], null);
    }

    static {
        try {
            style = IOUtil.readStreamAsString(DiffUtil.class.getResourceAsStream("diff.css"), "iso-8859-1");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class HTMLReportGenerator
    extends ReportGenerator {
        StringBuffer tableBuffer = new StringBuffer();
        StringBuffer output = new StringBuffer();
        private static final int MAX_LINE_LENGTH = 70;
        StringBuffer destLineBuffer = new StringBuffer();
        StringBuffer sourceLineBuffer = new StringBuffer();
        int sourceLineLength;
        int destLineLength;

        public HTMLReportGenerator(TextFile textFile1, TextFile textFile2) {
            super(textFile1, textFile2);
        }

        public void prepareHTMLReport(List diffReport, String outputFile, String title) throws IOException {
            IOUtil.write(outputFile, this.prepareHTMLReportAsText(diffReport, title));
        }

        public String prepareHTMLReportAsText(List diffReport, String title) {
            super.prepareReport(diffReport);
            this.output.append("<html>");
            this.output.append("<head>");
            if (title != null) {
                this.output.append("<title>");
                this.output.append(title);
                this.output.append("</title>");
            }
            this.output.append("<style>");
            this.output.append(style);
            this.output.append("</style>");
            this.output.append("</head>");
            this.output.append("<body>\n");
            if (title != null) {
                this.output.append("<h1>").append(title).append("</h1>");
            }
            this.output.append("<table class='tablestyle'>");
            this.output.append(this.tableBuffer);
            this.output.append("</table>\n");
            this.output.append("</body>");
            this.output.append("</html>");
            return this.output.toString();
        }

        protected void startLine() {
            this.sourceLineBuffer = new StringBuffer();
            this.destLineBuffer = new StringBuffer();
        }

        protected void finishLine(int sourceLine, int destLine) {
            StringBuffer buffer = this.tableBuffer;
            buffer.append("<tr>");
            this.insertLineColumn(sourceLine, 1, buffer);
            buffer.append("<td class='textcolumnstyle'>\n");
            buffer.append(this.sourceLineBuffer);
            buffer.append("</td>\n");
            this.insertLineColumn(destLine, 1, buffer);
            buffer.append("<td class='textcolumnstyle'>\n");
            buffer.append(this.destLineBuffer);
            buffer.append("</td>\n");
            buffer.append("</tr>");
            this.sourceLineBuffer.setLength(0);
            this.destLineBuffer.setLength(0);
            this.resetLine(true);
            this.resetLine(false);
        }

        protected void outputLine(boolean source, int index, int changeType) {
            StringBuffer buffer = this.tableBuffer;
            if (source) {
                buffer.append("<tr>");
            }
            this.insertLineColumn(index, changeType, buffer);
            buffer.append("<td>\n");
            if (index != -1) {
                TextLine line = this.getLine(source, index);
                String lineStr = line.getLine();
                this.appendText(lineStr, changeType, source);
                if (source) {
                    buffer.append(this.sourceLineBuffer);
                    this.sourceLineBuffer.setLength(0);
                } else {
                    buffer.append(this.destLineBuffer);
                    this.destLineBuffer.setLength(0);
                }
            }
            this.resetLine(source);
            buffer.append("</td>\n");
            if (!source) {
                buffer.append("</tr>\n");
            }
        }

        private void resetLine(boolean source) {
            if (source) {
                this.sourceLineLength = 0;
            } else {
                this.destLineLength = 0;
            }
        }

        private String toHTMLText(String lineStr) {
            String s = XMLWriterUtil.toValueString(lineStr);
            s = StringUtils.replace(s, " ", "&nbsp;");
            s = StringUtils.replace(s, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
            return s;
        }

        private void insertLineColumn(int index, int changeType, StringBuffer buffer) {
            if (changeType == 0) {
                buffer.append("<td class='linenumberstyle'>");
            } else {
                buffer.append("<td class='linenumberstyle linechange'>");
            }
            if (index != -1) {
                buffer.append(index + 1);
            }
            buffer.append("</td>");
        }

        protected void outputChars(boolean source, String text, int index, int length, int changeType) {
            String subText = text.substring(index, index + length);
            this.appendText(subText, changeType, source);
        }

        private void appendLineText(String subText, int changeType, boolean source) {
            this.appendText(subText, changeType, source);
            if (source) {
                // empty if block
            }
        }

        private void appendText(String subText, int changeType, boolean source) {
            int length;
            StringBuffer buffer;
            if (source) {
                buffer = this.sourceLineBuffer;
                length = this.sourceLineLength;
            } else {
                buffer = this.destLineBuffer;
                length = this.destLineLength;
            }
            while (length + subText.length() > 70) {
                int remain = 70 - length;
                String front = subText.substring(0, remain);
                this.appendText(front, changeType, buffer, source);
                buffer.append("<!-- line wrap -->");
                buffer.append("<br>");
                subText = subText.substring(remain);
                length = 0;
            }
            if (subText.length() > 0) {
                this.appendText(subText, changeType, buffer, source);
                length += subText.length();
            }
            if (source) {
                this.sourceLineLength = length;
            } else {
                this.destLineLength = length;
            }
        }

        private void appendText(String subText, int changeType, StringBuffer buffer, boolean source) {
            if (changeType == 0) {
                buffer.append("<span class='nochange'>");
                buffer.append(this.toHTMLText(subText));
                buffer.append("</span>");
            } else if (changeType == 3) {
                buffer.append("<ins class='added'>");
                buffer.append(this.toHTMLText(subText));
                buffer.append("</ins>");
            } else if (changeType == 2) {
                buffer.append("<del class='deleted'>");
                buffer.append(this.toHTMLText(subText));
                buffer.append("</del>");
            } else if (changeType == 1) {
                if (source) {
                    buffer.append("<del class='deleted'>");
                    buffer.append(this.toHTMLText(subText));
                    buffer.append("</del>");
                } else {
                    buffer.append("<ins class='added'>");
                    buffer.append(this.toHTMLText(subText));
                    buffer.append("</ins>");
                }
            }
            buffer.append("\n");
        }
    }

    static abstract class ReportGenerator {
        TextFile textFile1;
        TextFile textFile2;

        public ReportGenerator(TextFile textFile1, TextFile textFile2) {
            this.textFile1 = textFile1;
            this.textFile2 = textFile2;
        }

        public void prepareReport(List diffReport) {
            boolean ignoreNoChangeLines = false;
            if (this.textFile1.size() > 5000 || this.textFile2.size() > 5000) {
                ignoreNoChangeLines = true;
            }
            block6: for (int i = 0; i < diffReport.size(); ++i) {
                DiffResultSpan span = (DiffResultSpan)diffReport.get(i);
                int sourceIndex = span.getSourceIndex();
                int destIndex = span.getDestIndex();
                int length = span.getLength();
                switch (span.getStatus()) {
                    case 0: {
                        if (ignoreNoChangeLines) continue block6;
                        for (int j = 0; j < length; ++j) {
                            this.outputLine(true, sourceIndex + j, 0);
                            this.outputLine(false, destIndex + j, 0);
                        }
                        continue block6;
                    }
                    case 1: {
                        int j;
                        List detailedReports = (List)span.getUserObject();
                        for (j = 0; j < length; ++j) {
                            List detailedReport = (List)detailedReports.get(j);
                            this.prepareLineReport(detailedReport, sourceIndex + j, destIndex + j);
                        }
                        continue block6;
                    }
                    case 2: {
                        int j;
                        for (j = 0; j < length; ++j) {
                            this.outputLine(true, sourceIndex + j, 2);
                            this.outputLine(false, -1, 2);
                        }
                        continue block6;
                    }
                    case 3: {
                        int j;
                        for (j = 0; j < length; ++j) {
                            this.outputLine(true, -1, 3);
                            this.outputLine(false, destIndex + j, 3);
                        }
                        continue block6;
                    }
                }
            }
        }

        private void prepareLineReport(List detailedReport, int srcLineNo, int destLineNo) {
            String sourceLine = ((TextLine)this.textFile1.get(srcLineNo)).getLine();
            String destLine = ((TextLine)this.textFile2.get(destLineNo)).getLine();
            this.startLine();
            block6: for (int k = 0; k < detailedReport.size(); ++k) {
                DiffResultSpan span = (DiffResultSpan)detailedReport.get(k);
                int sourceIndex = span.getSourceIndex();
                int destIndex = span.getDestIndex();
                int length = span.getLength();
                switch (span.getStatus()) {
                    case 0: {
                        this.outputChars(true, sourceLine, sourceIndex, length, 0);
                        this.outputChars(false, destLine, destIndex, length, 0);
                        continue block6;
                    }
                    case 1: {
                        this.outputChars(true, sourceLine, sourceIndex, length, 1);
                        this.outputChars(false, destLine, destIndex, length, 1);
                        continue block6;
                    }
                    case 2: {
                        this.outputChars(true, sourceLine, sourceIndex, length, 2);
                        continue block6;
                    }
                    case 3: {
                        this.outputChars(false, destLine, destIndex, length, 3);
                    }
                }
            }
            this.finishLine(srcLineNo, destLineNo);
        }

        protected TextLine getLine(boolean source, int index) {
            if (source) {
                return (TextLine)this.textFile1.get(index);
            }
            return (TextLine)this.textFile2.get(index);
        }

        protected abstract void outputLine(boolean var1, int var2, int var3);

        protected abstract void outputChars(boolean var1, String var2, int var3, int var4, int var5);

        protected abstract void startLine();

        protected abstract void finishLine(int var1, int var2);
    }
}

