/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

import com.tplus.transform.util.diff.DiffResultSpan;
import com.tplus.transform.util.diff.TextFile;
import com.tplus.transform.util.diff.TextLine;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Masker {
    private TextFile textFile1;
    private TextFile textFile2;
    private static final int MASK = 8;
    Masks sourceMasks = new Masks();
    Masks destMasks = new Masks();

    void prepareMask(TextFile textFile1, TextFile textFile2, List maskExpressions) {
        this.textFile1 = textFile1;
        this.textFile2 = textFile2;
        this.mask(textFile1, this.sourceMasks, maskExpressions);
        this.mask(textFile2, this.destMasks, maskExpressions);
    }

    private void mask(TextFile textFile, Masks masks, List maskExpressions) {
        for (int i = 0; i < textFile.size(); ++i) {
            TextLine line = (TextLine)textFile.get(i);
            for (int j = 0; j < maskExpressions.size(); ++j) {
                MaskExpression maskExpression = (MaskExpression)maskExpressions.get(j);
                maskExpression.apply(line.getLine(), i, masks);
            }
        }
    }

    void maskDiffs(List diffReport) {
        block6: for (int i = 0; i < diffReport.size(); ++i) {
            DiffResultSpan span = (DiffResultSpan)diffReport.get(i);
            int sourceIndex = span.getSourceIndex();
            int destIndex = span.getDestIndex();
            int length = span.getLength();
            int status = span.getStatus();
            switch (status) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    int j;
                    List detailedReports = (List)span.getUserObject();
                    for (j = 0; j < length; ++j) {
                        List detailedReport = (List)detailedReports.get(j);
                        this.detailedReportMask(detailedReport, sourceIndex + j, destIndex + j);
                    }
                    continue block6;
                }
                case 2: {
                    int j;
                    for (j = 0; j < length; ++j) {
                        if (!this.maskLine(sourceIndex + j, this.sourceMasks)) continue;
                        this.maskDiff(span, status);
                    }
                    continue block6;
                }
                case 3: {
                    int j;
                    for (j = 0; j < length; ++j) {
                        if (!this.maskLine(destIndex + j, this.destMasks)) continue;
                        this.maskDiff(span, status);
                    }
                    continue block6;
                }
            }
        }
    }

    private void maskDiff(DiffResultSpan span, int status) {
        span.set_status(status | 8);
    }

    private boolean maskLine(int line, Masks sourceMasks) {
        List masks = sourceMasks.getMasks();
        for (int i = 0; i < masks.size(); ++i) {
            Mask mask = (Mask)masks.get(i);
        }
        return false;
    }

    private boolean maskChars(int startLine, int startIndex, int endLine, int endIndex, Masks sourceMasks) {
        return false;
    }

    private void detailedReportMask(List detailedReport, int srcLineNo, int destLineNo) {
        String sourceLine = ((TextLine)this.textFile1.get(srcLineNo)).getLine();
        String destLine = ((TextLine)this.textFile2.get(destLineNo)).getLine();
        block6: for (int k = 0; k < detailedReport.size(); ++k) {
            DiffResultSpan span = (DiffResultSpan)detailedReport.get(k);
            int sourceIndex = span.getSourceIndex();
            int destIndex = span.getDestIndex();
            int length = span.getLength();
            int status = span.getStatus();
            switch (status) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    if (!this.maskChars(srcLineNo, sourceIndex, srcLineNo, sourceIndex + length, this.sourceMasks) || !this.maskChars(destLineNo, destIndex, destLineNo, destIndex + length, this.destMasks)) continue block6;
                    this.maskDiff(span, status);
                    continue block6;
                }
                case 2: {
                    if (!this.maskChars(srcLineNo, sourceIndex, srcLineNo, sourceIndex + length, this.sourceMasks)) continue block6;
                    this.maskDiff(span, status);
                    continue block6;
                }
                case 3: {
                    if (!this.maskChars(destLineNo, destIndex, destLineNo, destIndex + length, this.destMasks)) continue block6;
                    this.maskDiff(span, status);
                }
            }
        }
    }

    class RegexMaskExpression
    implements MaskExpression {
        Pattern pattern;

        RegexMaskExpression(String patternStr) {
            this.pattern = Pattern.compile(patternStr);
        }

        public void apply(String textLine, int line, Masks masks) {
            Matcher matcher = this.pattern.matcher(textLine);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.start();
                masks.addMask(line, start, line, end);
            }
        }

        public void apply(TextFile textFile, Masks masks) {
        }
    }

    static interface MaskExpression {
        public void apply(String var1, int var2, Masks var3);

        public void apply(TextFile var1, Masks var2);
    }

    static class Mask {
        Range range;

        Mask(int startLine, int startOffset, int endLine, int endOffset) {
            this.range = new Range(startLine, startOffset, endLine, endOffset);
        }
    }

    static class Range {
        int startLine;
        int startOffset;
        int endLine;
        int endOffset;

        Range(int startLine, int startOffset, int endLine, int endOffset) {
            this.startLine = startLine;
            this.startOffset = startOffset;
            this.endLine = endLine;
            this.endOffset = endOffset;
        }

        boolean intersects(Range from) {
            if (this.startLine > from.startLine || this.endLine > from.endLine || this.startLine != from.startLine || this.startOffset <= from.startOffset) {
                // empty if block
            }
            return false;
        }

        public boolean matchLine(int line) {
            return this.startLine <= line && line <= this.endLine;
        }
    }

    static class Masks {
        List masks = new ArrayList();

        Masks() {
        }

        void addMask(int startLine, int startOffset, int endLine, int endOffset) {
            this.masks.add(new Mask(startLine, startOffset, endLine, endOffset));
        }

        public List getMasks() {
            return this.masks;
        }
    }
}

