/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

import com.tplus.transform.util.diff.DiffEngine;
import com.tplus.transform.util.diff.DiffResultSpan;
import com.tplus.transform.util.diff.EqualsElementComparator;
import com.tplus.transform.util.diff.WordData;
import com.tplus.transform.util.xml.XMLUtils;
import java.util.List;

public class StringDiff {
    StringBuffer toRet;
    private int state = -1;
    static final String DEL_START = "<font color='#FF0000'><strike>";
    static final String DEL_END = "</strike></font>";
    static final String NORMAL_START = "";
    static final String NORMAL_END = "";
    static final String ADD_START = "<font color='#008000'><u>";
    static final String ADD_END = "</u></font>";
    private static final int UNCHANGED = 2;
    private static final int NEW = 1;
    private static final int DELETED = 0;

    public static String diff(Object obj1, Object obj2) {
        return new StringDiff().diff0(obj1, obj2);
    }

    public static String diffWithStyle(String str1, String str2) {
        return new StringDiff().diffWithStyle0(str1, str2);
    }

    private String diff0(Object obj1, Object obj2) {
        return this.diff0(obj1 != null ? obj1.toString() : null, obj2 != null ? obj2.toString() : null, false);
    }

    private String diffWithStyle0(String str1, String str2) {
        return this.diff0(str1, str2, true);
    }

    private String diff0(String str1, String str2, boolean full) {
        if (str1 == null && str2 == null) {
            return "";
        }
        this.toRet = new StringBuffer();
        if (full) {
            this.toRet.append("<html>");
            this.toRet.append("<style>");
            this.toRet.append("<!--");
            this.toRet.append(".newtext {  font-family: Verdana,Arial,Helvetica, sans-serif;  font-weight:normal; color: #00FF00; }");
            this.toRet.append(".deltext {  font-family: Verdana,Arial,Helvetica, sans-serif;  font-weight:normal; color: #FF0000; }");
            this.toRet.append("-->");
            this.toRet.append("</style>");
        }
        if (str1 == null) {
            this.startNew();
            this.addText(str2);
        } else if (str2 == null) {
            this.startDel();
            this.addText(str1);
        } else if (str1.equals(str2)) {
            this.startNormal();
            this.addText(str2);
        } else {
            DiffEngine engine = new DiffEngine();
            WordData source = new WordData(str1);
            WordData dest = new WordData(str2);
            engine.processDiff(source, dest, new EqualsElementComparator());
            List report = engine.DiffReport();
            block6: for (int i = 0; i < report.size(); ++i) {
                DiffResultSpan span = (DiffResultSpan)report.get(i);
                switch (span.getStatus()) {
                    case 0: {
                        this.startNormal();
                        this.addText(source.getString(span.getSourceIndex(), span.getLength()));
                        continue block6;
                    }
                    case 1: {
                        this.startDel();
                        this.addText(source.getString(span.getSourceIndex(), span.getLength()));
                        this.startNew();
                        this.addText(dest.getString(span.getDestIndex(), span.getLength()));
                        continue block6;
                    }
                    case 2: {
                        this.startDel();
                        this.addText(source.getString(span.getSourceIndex(), span.getLength()));
                        continue block6;
                    }
                    case 3: {
                        this.startNew();
                        this.addText(dest.getString(span.getDestIndex(), span.getLength()));
                    }
                }
            }
        }
        if (full) {
            this.toRet.append("</html>");
        }
        return StringDiff.formatAsHTMLText(this.toRet.toString());
    }

    private void startNormal() {
        if (this.state != 2) {
            this.finishState();
            this.toRet.append("");
            this.state = 2;
        }
    }

    private void startNew() {
        if (this.state != 1) {
            this.finishState();
            this.toRet.append(ADD_START);
            this.state = 1;
        }
    }

    private void startDel() {
        if (this.state != 0) {
            this.finishState();
            this.toRet.append(DEL_START);
            this.state = 0;
        }
    }

    private void finishState() {
        if (this.state != -1) {
            String finishString = this.state == 0 ? DEL_END : (this.state == 1 ? ADD_END : "");
            this.toRet.append(finishString);
        }
    }

    private void addText(String str) {
        this.toRet.append(XMLUtils.replaceXMLEntities(str, false));
    }

    public static String formatAsHTMLText(Object columnValue) {
        if (columnValue == null) {
            return null;
        }
        String tempValue = columnValue.toString();
        StringBuffer buffer = new StringBuffer();
        boolean lastWhiteSpace = true;
        for (int i = 0; i < tempValue.length(); ++i) {
            char c = tempValue.charAt(i);
            if (c == '\r' || c == '\n') {
                buffer.append("<br>");
                if (c != '\r' || i >= tempValue.length() - 1 || tempValue.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            if (c == ' ') {
                if (lastWhiteSpace) {
                    buffer.append("&nbsp;");
                    continue;
                }
                lastWhiteSpace = true;
            } else {
                if (c == '\t') {
                    buffer.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    lastWhiteSpace = true;
                    continue;
                }
                lastWhiteSpace = false;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

