/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.diff.IDiffList;
import com.tplus.transform.util.diff.TextLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class TextFile
implements IDiffList {
    private List _lines;
    private String fileName;
    private String content;

    public TextFile(String fileName) throws IOException {
        this._lines = new ArrayList();
        this.fileName = fileName;
        this.read(new FileReader(fileName));
    }

    public String getContent() {
        if (this.content == null) {
            try {
                this.content = IOUtil.readFileAsString(this.fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.content;
    }

    public TextFile(String content, boolean containContent) {
        this.content = content;
        this._lines = new ArrayList();
        try {
            this.read(new StringReader(content));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        if (this.fileName != null) {
            return new File(this.fileName).getName();
        }
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private void read(Reader reader) throws IOException {
        String line;
        BufferedReader sr = new BufferedReader(reader);
        while ((line = sr.readLine()) != null) {
            this._lines.add(new TextLine(line));
        }
    }

    public int size() {
        return this._lines.size();
    }

    public Object get(int index) {
        return this._lines.get(index);
    }
}

