/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.io;

import com.tplus.transform.util.io.FilePermission;
import com.tplus.transform.util.io.FilePermissionJRE6;
import com.tplus.transform.util.io.FilePermissionNoOp;
import java.io.File;
import java.io.IOException;

public class FileUtil {
    public static boolean DEFAULT_OWNER_ONLY = true;
    static FilePermission filePermission = new FilePermissionNoOp();

    public static void elevateFileUserPermission(String fileName) {
        FileUtil.elevateFileUserPermission(new File(fileName));
    }

    public static void elevateFileUserPermission(File file) {
        if (!DEFAULT_OWNER_ONLY) {
            filePermission.setPermission(file, true, true, DEFAULT_OWNER_ONLY);
        }
    }

    public static void setExecutable(File file) {
        filePermission.setPermission(file, true, true, true, DEFAULT_OWNER_ONLY);
    }

    public static void applyToAllUsers(boolean bl) {
        DEFAULT_OWNER_ONLY = !bl;
    }

    public static boolean mkdir(File file) {
        return FileUtil.mkdir(file, DEFAULT_OWNER_ONLY);
    }

    public static boolean mkdir(File file, boolean ownerOnly) {
        try {
            boolean toRet = file.mkdir();
            if (file.exists() && !ownerOnly) {
                filePermission.setPermission(file, true, true, ownerOnly);
            }
            return toRet;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean mkdirs(File file) {
        return FileUtil.mkdirs(file, DEFAULT_OWNER_ONLY);
    }

    public static boolean mkdirs(File file, boolean ownerOnly) {
        if (file.exists()) {
            return false;
        }
        if (FileUtil.mkdir(file, ownerOnly)) {
            return true;
        }
        File canonFile = null;
        try {
            canonFile = file.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parent = canonFile.getParentFile();
        return parent != null && (FileUtil.mkdirs(parent, ownerOnly) || parent.exists()) && FileUtil.mkdir(canonFile, ownerOnly);
    }

    static {
        try {
            FilePermissionJRE6 jre6FilePermission = new FilePermissionJRE6();
            jre6FilePermission.test();
            filePermission = jre6FilePermission;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

