/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.io;

import com.tplus.transform.util.io.FileInfo;
import com.tplus.transform.util.io.FileSystemInternal;
import com.tplus.transform.util.io.PlatformFileInfo;
import java.io.File;

public class PlatformFileSystem
implements FileSystemInternal {
    static PlatformFileSystem platformFileSystem;

    protected PlatformFileSystem() {
    }

    public FileInfo getParent(FileInfo info) {
        return new PlatformFileInfo(this.getPlatformFile(info).getParentFile(), this);
    }

    public boolean isDirectory(FileInfo info) {
        return this.getPlatformFile(info).isDirectory();
    }

    public FileInfo[] listFiles(FileInfo info) {
        File[] files = this.getPlatformFile(info).listFiles();
        return this.createArray(files);
    }

    FileInfo[] createArray(File[] files) {
        FileInfo[] fileInfos = new FileInfo[files.length];
        for (int i = 0; i < files.length; ++i) {
            fileInfos[i] = new PlatformFileInfo(files[i], this);
        }
        return fileInfos;
    }

    public boolean createDirectory(FileInfo info) {
        return this.getPlatformFile(info).mkdirs();
    }

    public boolean deleteDirectory(FileInfo info) {
        return this.getPlatformFile(info).delete();
    }

    public boolean delete(FileInfo info) {
        return new File(info.getQualifiedName()).delete();
    }

    public boolean exists(FileInfo info) {
        return this.getPlatformFile(info).exists();
    }

    public FileInfo[] getRoots() {
        return this.createArray(File.listRoots());
    }

    public FileInfo createFileInfo(String parent, String child) {
        return new PlatformFileInfo(new File(parent, child), this);
    }

    public FileInfo createFileInfo(FileInfo parent, String child) {
        return new PlatformFileInfo(new File(this.getPlatformFile(parent), child), this);
    }

    public FileInfo createFileInfo(String path) {
        return new PlatformFileInfo(new File(path), this);
    }

    protected File getPlatformFile(FileInfo fileInfo) {
        return new File(fileInfo.getQualifiedName());
    }

    public String getQualfiedName(String qName) {
        return qName;
    }

    public static PlatformFileSystem getPlatformFileSystem() {
        return platformFileSystem;
    }
}

