/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log;

import com.tplus.transform.util.log.AbstractLogger;
import com.tplus.transform.util.log.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDKLogger
extends AbstractLogger {
    protected transient Logger logger = null;
    protected String name = null;

    public JDKLogger(String name) {
        this.name = name;
        this.logger = this.getLogger();
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.name);
        }
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    public void debug(Object message, Throwable exception) {
        this.logImpl(Level.FINE, String.valueOf(message), exception);
    }

    public void error(Object message, Throwable exception) {
        this.logImpl(Level.SEVERE, String.valueOf(message), exception);
    }

    public void fatal(Object message, Throwable exception) {
        this.logImpl(Level.SEVERE, String.valueOf(message), exception);
    }

    public void setLevel(Log.LogLevel level) {
        Level cmpLevel = Level.ALL;
        if (level == DEBUG) {
            cmpLevel = Level.FINEST;
        }
        if (level == INFO) {
            cmpLevel = Level.INFO;
        }
        if (level == ERROR) {
            cmpLevel = Level.SEVERE;
        }
        if (level == FATAL) {
            cmpLevel = Level.SEVERE;
        }
        if (level == WARN) {
            cmpLevel = Level.WARNING;
        }
        if (level == TRACE) {
            cmpLevel = Level.FINEST;
        }
        this.getLogger().setLevel(cmpLevel);
    }

    public void info(Object message, Throwable exception) {
        this.logImpl(Level.INFO, String.valueOf(message), exception);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isLoggable(Level.WARNING);
    }

    public void trace(Object message, Throwable exception) {
        this.logImpl(Level.FINEST, String.valueOf(message), exception);
    }

    public void warn(Object message, Throwable exception) {
        this.logImpl(Level.WARNING, String.valueOf(message), exception);
    }

    private void logImpl(Level level, String msg, Throwable ex) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(level)) {
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String cname = "unknown";
            String method = "unknown";
            if (locations != null && locations.length > 3) {
                StackTraceElement caller = locations[3];
                cname = caller.getClassName();
                method = caller.getMethodName();
            }
            msg = JDKLogger.sanitizeMessage(msg);
            if (ex == null) {
                logger.logp(level, cname, method, msg);
            } else {
                logger.logp(level, cname, method, msg, ex);
            }
        }
    }
}

