/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log;

import com.tplus.transform.util.log.AbstractLogger;
import com.tplus.transform.util.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogger
extends AbstractLogger {
    protected transient Logger logger = null;
    static boolean newLogger;
    static boolean tested;
    protected String name = null;
    private static final String FQCN;

    public SLF4JLogger(String name) {
        this.name = name;
        this.logger = this.getLogger();
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger((String)this.name);
            SLF4JLogger.testLogger();
        }
        return this.logger;
    }

    private static void testLogger() {
        if (!tested) {
            try {
                LocationAwareLogger.class.getDeclaredMethod("log", Marker.class, String.class, Integer.TYPE, String.class, Object[].class, Throwable.class);
                newLogger = true;
            }
            catch (NoSuchMethodException e) {
                newLogger = false;
            }
            catch (Exception e) {
                newLogger = false;
            }
            catch (Error e) {
                newLogger = false;
            }
            tested = true;
        }
    }

    public void debug(Object message, Throwable exception) {
        this.logImpl(10, this.toMessageString(message), exception);
    }

    private String toMessageString(Object message) {
        return message.toString();
    }

    public void error(Object message, Throwable exception) {
        this.logImpl(40, this.toMessageString(message), exception);
    }

    public void fatal(Object message, Throwable exception) {
        this.logImpl(40, this.toMessageString(message), exception);
    }

    public void setLevel(Log.LogLevel level) {
    }

    public void info(Object message, Throwable exception) {
        this.logImpl(20, this.toMessageString(message), exception);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    public void trace(Object message, Throwable exception) {
        this.logImpl(0, this.toMessageString(message), exception);
    }

    public void warn(Object message, Throwable exception) {
        this.logImpl(30, this.toMessageString(message), exception);
    }

    void logImpl(int level, String message, Throwable t) {
        message = SLF4JLogger.sanitizeMessage(message);
        if (this.logger instanceof LocationAwareLogger && newLogger) {
            this.logSLF4J(level, message, t);
        } else {
            switch (level) {
                case 10: {
                    this.logger.debug(this.toMessageString(message), t);
                    break;
                }
                case 40: {
                    this.logger.error(this.toMessageString(message), t);
                    break;
                }
                case 20: {
                    this.logger.info(this.toMessageString(message), t);
                    break;
                }
                case 0: {
                    this.logger.trace(this.toMessageString(message), t);
                    break;
                }
                case 30: {
                    this.logger.warn(this.toMessageString(message), t);
                }
            }
        }
    }

    private void logSLF4J(int level, String message, Throwable t) {
        LocationAwareLogger locationAwareLogger = (LocationAwareLogger)this.logger;
        locationAwareLogger.log(null, FQCN, level, message, null, t);
    }

    static {
        FQCN = AbstractLogger.class.getName();
    }
}

