/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.performance;

import com.tplus.transform.lang.DoubleUtils;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.MathUtils;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.performance.LatencyInfo;
import com.tplus.transform.util.performance.MessageLatency;
import com.tplus.transform.util.performance.MessageLatencyReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LatencyAnalyzer {
    String fileName;
    private int timeslot1;
    private int timeslot2;
    int ignoreStartDataPoints;
    LatencyInfo latencyInfo = new LatencyInfo();
    public static String FS = "\t";

    public LatencyAnalyzer(String fileName, int timeslot1, int timeslot2) {
        this.fileName = fileName;
        this.timeslot1 = timeslot1;
        this.timeslot2 = timeslot2;
    }

    public int getIgnoreStartDataPoints() {
        return this.ignoreStartDataPoints;
    }

    public void setIgnoreStartDataPoints(int ignoreStartDataPoints) {
        this.ignoreStartDataPoints = ignoreStartDataPoints;
    }

    void dump() throws IOException {
        MessageLatency messageLatency;
        MessageLatencyReader messageLatencyReader = new MessageLatencyReader(this.fileName, this.ignoreStartDataPoints);
        while ((messageLatency = messageLatencyReader.read()) != null) {
            for (int i = 1; i < messageLatency.getSlots(); ++i) {
                long elapsed = messageLatency.getTime(i) - messageLatency.getTime(0);
                System.out.print(elapsed + ", ");
            }
            System.out.println();
        }
    }

    LatencyInfo compute() throws IOException {
        this.computeStandardDeviation();
        return this.latencyInfo;
    }

    double computeStandardDeviation() throws IOException {
        double stdDeviation;
        MessageLatency messageLatency;
        double average = this.computeAverage();
        double range = average / (double)(this.latencyInfo.distributionCount / 2);
        this.latencyInfo.distributionRange[0] = 0.0;
        for (int i = 1; i < this.latencyInfo.distributionCount; ++i) {
            this.latencyInfo.distributionRange[i] = this.latencyInfo.distributionRange[i - 1] + range;
        }
        int[] distribution = new int[this.latencyInfo.distributionCount];
        MessageLatencyReader messageLatencyReader = new MessageLatencyReader(this.fileName, this.ignoreStartDataPoints);
        double total = 0.0;
        int count = 0;
        double maxLatency = 0.0;
        double minLatency = 2.147483647E9;
        while ((messageLatency = messageLatencyReader.read()) != null) {
            int slot;
            long latency = messageLatency.getTime(this.timeslot2) - messageLatency.getTime(this.timeslot1);
            int n = slot = this.getSlot(latency, this.latencyInfo.distributionRange, average);
            distribution[n] = distribution[n] + 1;
            double deviation = Math.abs((double)latency - average);
            total += deviation * deviation;
            ++count;
            maxLatency = Math.max((double)latency, maxLatency);
            minLatency = Math.min((double)latency, minLatency);
        }
        this.latencyInfo.std = stdDeviation = Math.sqrt(total / (double)(count - 1));
        this.latencyInfo.maxLatency = maxLatency;
        this.latencyInfo.minLatency = minLatency;
        this.computeDistributionPercentage(distribution);
        return stdDeviation;
    }

    private void setDistributionCount(int count) {
        this.latencyInfo.setDistributionCount(count);
    }

    private void computeDistributionPercentage(int[] distribution) {
        for (int i = 0; i < this.latencyInfo.distributionCount; ++i) {
            double percent;
            int count = distribution[i];
            this.latencyInfo.distributionPercentage[i] = percent = (double)count * 100.0 / (double)this.latencyInfo.totalCount;
        }
    }

    private int getSlot(long value, double[] distributionRange, double average) {
        for (int i = 0; i < distributionRange.length; ++i) {
            double v = distributionRange[i];
            if (!((double)value < v)) continue;
            return i - 1;
        }
        return distributionRange.length - 1;
    }

    double computeAverage() throws IOException {
        double average;
        MessageLatency messageLatency;
        MessageLatencyReader messageLatencyReader = new MessageLatencyReader(this.fileName, this.ignoreStartDataPoints);
        double total = 0.0;
        int count = 0;
        while ((messageLatency = messageLatencyReader.read()) != null) {
            long elapsed = messageLatency.getTime(this.timeslot2) - messageLatency.getTime(this.timeslot1);
            total += (double)elapsed;
            ++count;
        }
        this.latencyInfo.average = average = total / (double)count;
        this.latencyInfo.totalCount = count;
        return average;
    }

    public static void main2(String[] args) throws IOException {
        String fileName = args[0];
        LatencyAnalyzer latencyAnalyzer = new LatencyAnalyzer(fileName, 0, 1);
        int ignore = 4000;
        int distributionCount = 10;
        PrintStream out = System.out;
        out.println("Send Time vs Publish time");
        out.println("----------------------------");
        LatencyAnalyzer.analyze(out, fileName, 0, 4, ignore, distributionCount);
        out.println("Receive Time vs Publish time");
        out.println("----------------------------");
        LatencyAnalyzer.analyze(out, fileName, 1, 4, ignore, distributionCount);
        out.println("Receive Time vs parse time");
        out.println("----------------------------");
        LatencyAnalyzer.analyze(out, fileName, 1, 2, ignore, distributionCount);
        out.println("Parse Time vs Publish time");
        out.println("----------------------------");
        LatencyAnalyzer.analyze(out, fileName, 2, 4, ignore, distributionCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cmtmain(String[] args) throws IOException {
        ArrayList allFiles = new ArrayList();
        if (args.length == 0) {
            LatencyAnalyzer.showSyntax();
            System.exit(-1);
        }
        int fromTime = 1;
        int toTime = 4;
        int distributionCount = 10;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                String nextArg;
                String lower = arg.toLowerCase();
                if (lower.equalsIgnoreCase("-fromtime")) {
                    nextArg = args[i + 1];
                    fromTime = Integer.parseInt(nextArg);
                    ++i;
                }
                if (lower.equalsIgnoreCase("-totime")) {
                    nextArg = args[i + 1];
                    toTime = Integer.parseInt(nextArg);
                    ++i;
                }
                if (!lower.equalsIgnoreCase("-distribution")) continue;
                nextArg = args[i + 1];
                distributionCount = Integer.parseInt(nextArg);
                ++i;
                continue;
            }
            allFiles.addAll(LatencyAnalyzer.expandEntityArg(arg));
        }
        ArrayList<LatencyInfo> latencyInfos = new ArrayList<LatencyInfo>();
        for (int i = 0; i < allFiles.size(); ++i) {
            String fileName = (String)allFiles.get(i);
            String outputFilename = LatencyAnalyzer.replaceExtension(fileName, "txt");
            PrintStream ps = new PrintStream(new FileOutputStream(outputFilename));
            try {
                LatencyInfo latencyInfo = LatencyAnalyzer.analyze(ps, fileName, fromTime, toTime, 4000, distributionCount);
                latencyInfos.add(latencyInfo);
                continue;
            }
            finally {
                ps.close();
            }
        }
        if (latencyInfos.size() > 1) {
            LatencyAnalyzer.prepareSummary(allFiles, latencyInfos);
        }
    }

    private static void showSyntax() {
        System.out.println("latencyanalyzer [-fromtime slot] [-totime slot] [-distribution count] latencyfiles ... ");
        System.out.println("Example:");
        System.out.println("  latencyanalyzer *.latency");
        System.out.println("  latencyanalyzer -fromtime 1 -totime 4  t1.latency");
        System.out.println("Slots: Denotes time after the operation is done");
        System.out.println(" 0 - sent time");
        System.out.println(" 1 - receive time");
        System.out.println(" 2 - parse time");
        System.out.println(" 3 - process time");
        System.out.println(" 4 - publish time");
        System.out.println(" e.g. -fromtime 1 -totime 4  => Time taken from the time message is received till it is published.");
        System.out.println("Default:");
        System.out.println("  fromtime 1");
        System.out.println("  totime 1");
        System.out.println("  distribution 10");
    }

    private static void prepareSummary(List allFiles, List latencyInfos) throws FileNotFoundException {
        String summaryFile = new File(new File((String)allFiles.get(0)).getParent(), "Latency-Summary.txt").getAbsolutePath();
        PrintStream out = new PrintStream(new FileOutputStream(summaryFile));
        out.print("       Name       " + FS);
        out.print("Avg Lat" + FS);
        out.print("Std Dev " + FS);
        out.print("Max Lat" + FS);
        out.print("Min Lat");
        out.println();
        for (int i = 0; i < latencyInfos.size(); ++i) {
            LatencyInfo latencyInfo = (LatencyInfo)latencyInfos.get(i);
            out.print(latencyInfo.name + FS);
            out.print(LatencyAnalyzer.roundMicro(latencyInfo.average) + FS);
            out.print(LatencyAnalyzer.roundMicro(latencyInfo.std) + FS);
            out.print(LatencyAnalyzer.roundMicro(latencyInfo.maxLatency) + FS);
            out.print(LatencyAnalyzer.roundMicro(latencyInfo.minLatency));
            out.println();
        }
        out.close();
    }

    private static LatencyInfo analyze(PrintStream out, String latencyFileName, int slot1, int slot2, int ignore, int distributionCount) throws IOException {
        String name;
        System.out.println("Analyzing " + latencyFileName);
        DoubleUtils.NumberFormatInfo formatInfo = new DoubleUtils.NumberFormatInfo();
        LatencyAnalyzer latencyAnalyzer = new LatencyAnalyzer(latencyFileName, slot1, slot2);
        latencyAnalyzer.setDistributionCount(distributionCount);
        latencyAnalyzer.setIgnoreStartDataPoints(ignore);
        LatencyInfo latencyInfo = latencyAnalyzer.compute();
        latencyInfo.name = name = IOUtil.getBaseName(latencyFileName);
        out.println("Name            " + FS + name);
        out.println("Average Latency" + FS + LatencyAnalyzer.roundMicro(latencyInfo.average));
        out.println("Std Deviation " + FS + LatencyAnalyzer.roundMicro(latencyInfo.std));
        out.println("Max Latency " + FS + LatencyAnalyzer.roundMicro(latencyInfo.maxLatency));
        out.println("Min Latency " + FS + LatencyAnalyzer.roundMicro(latencyInfo.minLatency));
        out.println("Latency " + FS + "Distribution(%)");
        for (int i = 0; i < latencyInfo.distributionRange.length; ++i) {
            double v = latencyInfo.distributionRange[i];
            out.print(StringUtils.lpad(Double.toString(Math.round(v / 1000.0)), ' ', 8));
            out.print(FS);
            double percent = latencyInfo.distributionPercentage[i];
            out.print(StringUtils.lpad(Double.toString(MathUtils.round(percent, 2)), ' ', 8));
            out.println();
        }
        out.println();
        return latencyInfo;
    }

    private static String roundMicro(double value) {
        return StringUtils.lpad(Long.toString(Math.round(value / 1000.0)), ' ', 8);
    }

    private static List expandEntityArg(String entityArg) {
        File file;
        if ((entityArg.indexOf(47) != -1 || entityArg.indexOf(92) != -1 || entityArg.indexOf(42) != -1 || entityArg.indexOf(63) != -1) && (file = new File(entityArg)).isDirectory()) {
            List allFiles = IOUtil.getAllFiles(file.getAbsolutePath(), true);
            return allFiles;
        }
        return Collections.singletonList(entityArg);
    }

    public static String replaceExtension(String fileName, String outputExtension) {
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex == -1) {
            return fileName + "." + outputExtension;
        }
        return fileName.substring(0, dotIndex + 1) + outputExtension;
    }
}

