/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.performance;

import com.tplus.transform.io.SafeFile;
import com.tplus.transform.util.performance.MessageLatency;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;

public class MessageLatencyReader {
    long[] times;
    int version;
    int timeSlots;
    DataInputStream inputStream;
    int dataPoints;
    private int ignoreStartDataPoints;
    String[] slotNames;

    MessageLatencyReader(String fileName, int ignoreStartDataPoints) throws IOException {
        this.ignoreStartDataPoints = ignoreStartDataPoints;
        SafeFile.doFileCheck(fileName);
        this.inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        this.version = this.inputStream.readInt();
        this.readSlotInfo();
        this.times = new long[this.timeSlots];
    }

    private void readSlotInfo() throws IOException {
        this.timeSlots = this.inputStream.readInt();
        this.slotNames = new String[this.timeSlots];
        for (int i = 0; i < this.timeSlots; ++i) {
            this.slotNames[i] = this.inputStream.readUTF();
        }
    }

    public String[] getSlotNames() {
        return this.slotNames;
    }

    MessageLatency read() throws IOException {
        MessageLatency messageLatency = null;
        do {
            messageLatency = this.readImpl();
            ++this.dataPoints;
        } while (messageLatency != null && this.dataPoints < this.ignoreStartDataPoints);
        return messageLatency;
    }

    MessageLatency readImpl() throws IOException {
        try {
            MessageLatency messageLatency = new MessageLatency(this.timeSlots);
            for (int i = 0; i < this.timeSlots; ++i) {
                long time = this.inputStream.readLong();
                messageLatency.setTime(time, i);
            }
            return messageLatency;
        }
        catch (EOFException e) {
            return null;
        }
    }
}

