/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.performance;

import com.tplus.transform.util.performance.MessageLatency;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class MessageLatencyWriter {
    String fileName;
    private DataOutputStream writer;
    private static final int VERSION = 1;

    public MessageLatencyWriter(String fileName) throws IOException {
        this.fileName = fileName;
        this.writer = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
        this.writer.writeInt(1);
    }

    public synchronized void writeLatency(MessageLatency messageLatency) throws IOException {
        if (this.writer != null) {
            int slots = messageLatency.getSlots();
            for (int i = 0; i < slots; ++i) {
                this.writer.writeLong(messageLatency.getTime(i));
            }
        }
    }

    public void writeSlotInfo(String[] strings) throws IOException {
        this.writer.writeInt(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            this.writer.writeUTF(string);
        }
    }

    public synchronized void close() throws IOException {
        this.writer.flush();
        this.writer.close();
        this.writer = null;
    }
}

