/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.sql;

import com.tplus.transform.util.sql.SQLType;

public class SQLTypes {
    public static SQLType getSQLType(String name) {
        SQLType info = SQLType.valueOf(name);
        if (info == null) {
            throw new IllegalArgumentException("The type " + name + " is not a recognized SQL type");
        }
        return info;
    }

    public static String getSQLTypeName(int sqlType) {
        return SQLType.valueOf(sqlType).getName();
    }

    public static String getSQLTypeName(SQLType sqlType) {
        return sqlType.getName();
    }

    public static int getDefaultLength(SQLType sqlType) {
        return sqlType.getDefaultLength();
    }

    public static int getDefaultDecimal(SQLType sqlType) {
        return sqlType.getDefaultDecimal();
    }

    public static boolean isLengthValid(SQLType sqlType) {
        return sqlType.lengthApplies;
    }

    public static boolean isDecimalLengthValid(SQLType sqlType) {
        return sqlType.decimalLengthApplies;
    }

    private static SQLType getSQLType(int sqlType) {
        SQLType info = SQLType.valueOf(sqlType);
        if (info == null) {
            throw new IllegalArgumentException("The type " + sqlType + " is not a recognized SQL type");
        }
        return info;
    }
}

