/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.sql.connection;

import com.tplus.transform.io.SecurityTool;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.SequencedHashMap;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ConnectionInfo
implements Serializable {
    public static final String NAME = "name";
    public static final String URL = "url";
    public static final String DRIVER = "connection-driver";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String DIALECT = "dialect";
    public static final String LOCATION = "location";
    public static final String SERVER_LOCATION = "server-location";
    public static final String CLASS = "class";
    public static final String RESOURCE_ENCRYPTED_SUFFIX = "encrypted-resource-";
    public static final String ENCRYPTED_SUFFIX = "encrypted-";
    public static final String AUTO_COMMIT = "auto-commit";
    public static final String INACTIVITY_TIMEOUT = "inactivity-timeout";
    public static final String DB_TYPE = "dbType";
    protected static Log log = LogFactory.getLog(ConnectionInfo.class);
    ClassLoader classLoader;
    Map properties = new SequencedHashMap();
    static String[] dialects = new String[]{"hsql", "oracle", "mysql", "sybase", "mssql", "db2", "interbase", "progress", "sapdb", "postgres"};

    public ConnectionInfo() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void read(String fileName) throws IOException {
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(fileName);
        props.load(fis);
        fis.close();
        this.setProperties(props);
    }

    public String guessDialect() {
        String driver = this.getDriver().toLowerCase();
        String dialect = null;
        if (driver != null) {
            for (int i = 0; i < dialects.length; ++i) {
                if (driver.indexOf(dialects[i]) == -1) continue;
                return dialects[i];
            }
        }
        return dialect;
    }

    public void setProperties(Properties properties) {
        this.properties.putAll(properties);
    }

    public void setName(String name) {
        this.setProperty(NAME, name);
    }

    public void setURL(String url) {
        this.setProperty(URL, url);
    }

    public void setDriver(String driver) {
        this.setProperty(DRIVER, driver);
    }

    public void setUserName(String userName) {
        this.setProperty(USERNAME, userName);
    }

    public void setPassword(String password) {
        this.setProperty(PASSWORD, password);
    }

    public String getName() {
        return this.getProperty(NAME);
    }

    public String getURL() {
        return this.getPropertyAllowEncrypted(URL);
    }

    public String getDriver() {
        return this.getProperty(DRIVER);
    }

    public String getUserName() {
        return this.getPropertyAllowEncrypted(USERNAME);
    }

    public String getPassword() {
        return this.getPropertyAllowEncrypted(PASSWORD);
    }

    public String getDbType() {
        return this.getProperty(DB_TYPE);
    }

    public void setDbType(String dbType) {
        this.setProperty(DB_TYPE, dbType);
    }

    public boolean isAutoCommit() {
        String property = this.getProperty(AUTO_COMMIT);
        boolean autoCommit = Boolean.valueOf(property);
        return autoCommit;
    }

    public String getPropertyAllowEncrypted(String propertyName) {
        String value = this.getProperty(propertyName);
        if (value == null) {
            String ENCRYPTED_PROPERTY_NAME = ENCRYPTED_SUFFIX + propertyName;
            String encryptedValue = this.getProperty(ENCRYPTED_PROPERTY_NAME);
            if (encryptedValue != null) {
                try {
                    value = SecurityTool.decrypt(encryptedValue);
                }
                catch (Exception e) {
                    log.error("Error decrypting encrypted-" + propertyName + " attribute\n" + encryptedValue, e);
                }
            } else {
                String RESOURCE_ENCRYPTED_PROPERTY_NAME = RESOURCE_ENCRYPTED_SUFFIX + propertyName;
                String resourceEncryptedValue = this.getProperty(RESOURCE_ENCRYPTED_PROPERTY_NAME);
                if (resourceEncryptedValue != null) {
                    try {
                        InputStream resourceAsStream = this.classLoader.getResourceAsStream(resourceEncryptedValue);
                        if (resourceAsStream != null) {
                            String s = IOUtil.readStreamAsString(resourceAsStream);
                            s = s.trim();
                            value = SecurityTool.decrypt(s);
                        } else {
                            log.error("Error locating resource " + resourceEncryptedValue + " for connection attribute\n" + RESOURCE_ENCRYPTED_PROPERTY_NAME);
                        }
                    }
                    catch (Exception e) {
                        log.error("Error decrypting encrypted-" + propertyName + " attribute\n" + encryptedValue, e);
                    }
                }
            }
            if (value != null) {
                this.setProperty(propertyName, value);
            }
        }
        return value;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public String[] getProperties() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public Properties getAllProperties() {
        Properties allProperties = new Properties();
        allProperties.putAll((Map<?, ?>)this.properties);
        return allProperties;
    }

    public Properties getDriverProperties() {
        Properties driverProperties = new Properties();
        driverProperties.putAll((Map<?, ?>)this.properties);
        driverProperties.remove(NAME);
        driverProperties.remove(DRIVER);
        driverProperties.remove(URL);
        driverProperties.remove(DIALECT);
        driverProperties.remove(LOCATION);
        driverProperties.remove(CLASS);
        driverProperties.remove(USERNAME);
        driverProperties.remove(DB_TYPE);
        if (this.getUserName() != null) {
            driverProperties.put("user", this.getUserName());
        }
        return driverProperties;
    }

    public Map getOtherProperties() {
        SequencedHashMap otherProperties = new SequencedHashMap();
        otherProperties.putAll(this.properties);
        otherProperties.remove(DRIVER);
        otherProperties.remove(URL);
        otherProperties.remove(USERNAME);
        otherProperties.remove(PASSWORD);
        return otherProperties;
    }

    public void setOtherProperties(Map otherProperties) {
        Map exitingOtherProps = this.getOtherProperties();
        Iterator it = exitingOtherProps.keySet().iterator();
        while (it.hasNext()) {
            this.properties.remove(it.next());
        }
        this.properties.putAll(otherProperties);
    }

    public static Connection getConnection(ConnectionInfo connectionInfo) throws Exception {
        String driverClass = connectionInfo.getDriver();
        String connectionStr = connectionInfo.getURL();
        Properties props = connectionInfo.getDriverProperties();
        String dbuserName = connectionInfo.getUserName();
        String dbpassword = connectionInfo.getPassword();
        props.put("user", dbuserName);
        props.put(PASSWORD, dbpassword);
        Class.forName(driverClass);
        Connection con = DriverManager.getConnection(connectionStr, props);
        return con;
    }
}

