/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.sql.connection;

import com.tplus.transform.util.SequencedHashMap;
import com.tplus.transform.util.sql.SchemaException;
import com.tplus.transform.util.sql.connection.ConnectionInfo;
import com.tplus.transform.util.sql.connection.ConnectionXML;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConnectionInfoList {
    Map connectionMap = new SequencedHashMap();
    String defaultConnectionName = null;

    public static ConnectionInfoList read(String fileName) throws SchemaException {
        ConnectionXML connectionXML = new ConnectionXML();
        ConnectionInfoList connectionInfoList = connectionXML.read(fileName);
        return connectionInfoList;
    }

    public static ConnectionInfoList read(InputStream is) throws SchemaException {
        ConnectionXML connectionXML = new ConnectionXML();
        ConnectionInfoList connectionInfoList = connectionXML.read(is);
        return connectionInfoList;
    }

    public static void save(ConnectionInfoList connectionInfoList, String fileName) throws SchemaException {
        ConnectionXML connectionXML = new ConnectionXML();
        connectionXML.write(connectionInfoList, fileName);
    }

    public String[] getConnectionNames() {
        return this.connectionMap.keySet().toArray(new String[this.connectionMap.size()]);
    }

    public ConnectionInfo getConnectionInfo(String name) {
        return (ConnectionInfo)this.connectionMap.get(name);
    }

    public List getAllConnections() {
        ArrayList connections = new ArrayList();
        connections.addAll(this.connectionMap.values());
        return connections;
    }

    public void addConnectionInfo(ConnectionInfo connectionInfo) {
        String name = connectionInfo.getName();
        if (this.defaultConnectionName == null) {
            this.defaultConnectionName = name;
        }
        this.connectionMap.put(name, connectionInfo);
    }

    public void removeConnectionInfo(String name) {
        if (name.equals(this.defaultConnectionName)) {
            this.defaultConnectionName = null;
        }
        this.connectionMap.remove(name);
    }

    public ConnectionInfo getDefaultConnection() {
        if (this.defaultConnectionName == null) {
            return null;
        }
        return this.getConnectionInfo(this.defaultConnectionName);
    }

    public void setDefaultConnectionName(String name) {
        this.defaultConnectionName = name;
    }

    public String getDefaultConnectionName() {
        return this.defaultConnectionName;
    }
}

