/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.sql.connection;

import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.sql.SchemaException;
import com.tplus.transform.util.sql.connection.ConnectionInfo;
import com.tplus.transform.util.sql.connection.ConnectionInfoList;
import com.tplus.transform.util.sql.connection.XADataSourceConnectionInfo;
import com.tplus.transform.util.xml.XMLUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class ConnectionXML {
    public static final String lineSeparator = IOUtil.LINE_SEPARATOR;
    public static final String DATA_SOURCE_TAG = "data-source";
    public static final String DATA_SOURCES_TAG = "data-sources";
    public static final String DEFAULT_CONNECTION = "default-data-source";
    public static final String NAME_ATTRIB = "name";
    public static final String VALUE_ATTRIB = "value";
    public static final String XA_DATA_SOURCE_TAG = "xa-data-source";
    public static final String DATA_SOURCE_PROPERTY_TAG = "data-source-property";

    public ConnectionInfoList read(InputStream is) throws SchemaException {
        try {
            Document doc = XMLUtils.createDocument(new InputStreamReader(is));
            ConnectionInfoList infoList = new ConnectionInfoList();
            this.read(infoList, doc.getDocumentElement());
            return infoList;
        }
        catch (Exception e) {
            throw new SchemaException(e.getClass().getName() + ":" + e.getMessage());
        }
    }

    public ConnectionInfoList read(String fileName) throws SchemaException {
        try {
            Document doc = XMLUtils.createDocument(fileName);
            ConnectionInfoList infoList = new ConnectionInfoList();
            this.read(infoList, doc.getDocumentElement());
            return infoList;
        }
        catch (Exception e) {
            throw new SchemaException(e.getClass().getName() + ":" + e.getMessage());
        }
    }

    public void write(ConnectionInfoList infoList, String fileName) throws SchemaException {
        StringBuffer buffer = this.write(infoList);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(fileName));
        }
        catch (IOException e) {
            throw new SchemaException(e.getClass().getName() + ":" + e.getMessage());
        }
        try {
            writer.println(buffer);
        }
        catch (Exception e) {
            throw new SchemaException(e.getClass().getName() + ":" + e.getMessage());
        }
        finally {
            writer.close();
        }
    }

    public void write(ConnectionInfoList infoList, PrintWriter writer) throws SchemaException {
        StringBuffer buffer = this.write(infoList);
        writer.println(buffer);
    }

    public void read(ConnectionInfoList infoList, Element nd) throws SchemaException {
        String attrValue;
        Attr attr;
        ConnectionInfo connectionInfo;
        NamedNodeMap attribs;
        Element dsElm;
        int i;
        if (!nd.getTagName().equals(DATA_SOURCES_TAG)) {
            throw new SchemaException("The root tag name should be 'data-sources'");
        }
        String defaultConnection = nd.getAttribute(DEFAULT_CONNECTION);
        if (defaultConnection != null && defaultConnection.length() > 0) {
            infoList.setDefaultConnectionName(defaultConnection);
        }
        NodeList dataSourceList = nd.getElementsByTagName(DATA_SOURCE_TAG);
        for (i = 0; i < dataSourceList.getLength(); ++i) {
            dsElm = (Element)dataSourceList.item(i);
            attribs = dsElm.getAttributes();
            connectionInfo = new ConnectionInfo();
            for (int j = 0; j < attribs.getLength(); ++j) {
                attr = (Attr)attribs.item(j);
                String attrName = attr.getName();
                attrValue = attr.getValue();
                connectionInfo.setProperty(attrName, attrValue);
            }
            infoList.addConnectionInfo(connectionInfo);
        }
        dataSourceList = nd.getElementsByTagName(XA_DATA_SOURCE_TAG);
        for (i = 0; i < dataSourceList.getLength(); ++i) {
            dsElm = (Element)dataSourceList.item(i);
            attribs = dsElm.getAttributes();
            connectionInfo = new XADataSourceConnectionInfo();
            for (int j = 0; j < attribs.getLength(); ++j) {
                attr = (Attr)attribs.item(j);
                String attrName = attr.getName();
                attrValue = attr.getValue();
                connectionInfo.setProperty(attrName, attrValue);
            }
            NodeList propsList = dsElm.getElementsByTagName(DATA_SOURCE_PROPERTY_TAG);
            Properties properties = new Properties();
            for (int j = 0; j < propsList.getLength(); ++j) {
                Element propElm = (Element)propsList.item(j);
                String name = propElm.getAttribute(NAME_ATTRIB);
                String value = propElm.getAttribute(VALUE_ATTRIB);
                properties.put(name, value);
            }
            ((XADataSourceConnectionInfo)connectionInfo).setDataSourceProperties(properties);
            infoList.addConnectionInfo(connectionInfo);
        }
    }

    public StringBuffer write(ConnectionInfoList infoList) throws SchemaException {
        StringBuffer connectionBuffer = new StringBuffer();
        String defaultConnection = infoList.getDefaultConnectionName();
        connectionBuffer.append("<?xml version=\"1.0\"?>").append(lineSeparator);
        connectionBuffer.append("<").append(DATA_SOURCES_TAG).append(" ").append(DEFAULT_CONNECTION).append("=").append(this.getQuotedString(defaultConnection)).append(" >").append(lineSeparator);
        String[] names = infoList.getConnectionNames();
        for (int i = 0; i < names.length; ++i) {
            ConnectionInfo connectionInfo = infoList.getConnectionInfo(names[i]);
            StringBuffer connectionPropsBuffer = this.writeConnectionInfo(connectionInfo);
            connectionBuffer.append(connectionPropsBuffer.toString());
        }
        connectionBuffer.append("</").append(DATA_SOURCES_TAG).append(">").append(lineSeparator);
        return connectionBuffer;
    }

    StringBuffer writeConnectionInfo(ConnectionInfo connectionInfo) {
        StringBuffer conBuffer = new StringBuffer();
        if (connectionInfo instanceof XADataSourceConnectionInfo) {
            XADataSourceConnectionInfo xaConnectionInfo = (XADataSourceConnectionInfo)connectionInfo;
            conBuffer.append("    <").append(XA_DATA_SOURCE_TAG).append(" ").append(lineSeparator);
            String[] props = connectionInfo.getProperties();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i];
                String string = connectionInfo.getProperty(name);
                conBuffer.append("        ").append(name).append("=").append(this.getQuotedString(string)).append(lineSeparator);
            }
            Properties daprops = xaConnectionInfo.getDataSourceProperties();
            for (String string : daprops.keySet()) {
                String value = daprops.getProperty(string);
                conBuffer.append("<").append(DATA_SOURCE_PROPERTY_TAG).append(" ").append(NAME_ATTRIB).append("=").append(this.getQuotedString(string)).append(" ").append(VALUE_ATTRIB).append("=").append(this.getQuotedString(value)).append(" />").append(lineSeparator);
            }
            conBuffer.append("</").append(XA_DATA_SOURCE_TAG).append(">").append(lineSeparator);
        } else {
            conBuffer.append("    <").append(DATA_SOURCE_TAG).append(" ").append(lineSeparator);
            String[] props = connectionInfo.getProperties();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i];
                String value = connectionInfo.getProperty(name);
                conBuffer.append("        ").append(name).append("=").append(this.getQuotedString(value)).append(lineSeparator);
            }
            conBuffer.append("    />").append(lineSeparator);
        }
        return conBuffer;
    }

    String getQuotedString(String str) {
        return "\"" + str + "\"";
    }

    public static void main(String[] arg) throws Exception {
        ConnectionXML connectionXML = new ConnectionXML();
        ConnectionInfoList infoList = connectionXML.read(arg[0]);
        PrintWriter writer = new PrintWriter(System.out);
        connectionXML.write(infoList, writer);
        writer.flush();
    }
}

