/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.sql.connection;

import com.tplus.transform.util.sql.connection.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DBConnectionManager {
    ConnectionPool connectionPool;
    List statements = new ArrayList();
    private Connection connection;

    public DBConnectionManager(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.connectionPool.getConnection();
        }
        return this.connection;
    }

    public Statement createStatement(String statement) throws SQLException {
        Connection connection = this.getConnection();
        Statement stmt = connection.createStatement();
        this.statements.add(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String statement) throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement stmt = connection.prepareStatement(statement);
        this.statements.add(stmt);
        return stmt;
    }

    public void closeStatement(Statement stmt) throws SQLException {
        this.statements.remove(stmt);
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        try {
            this.clean();
            this.connectionPool.commit(this.connection);
        }
        finally {
            this.connectionPool.releaseConnection(this.connection);
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        try {
            this.clean();
            this.connectionPool.rollback(this.connection);
        }
        finally {
            this.connectionPool.releaseConnection(this.connection);
            this.connection = null;
        }
    }

    void clean() throws SQLException {
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement stmt = (Statement)this.statements.get(i);
            stmt.close();
        }
    }
}

