/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.sql.connection;

import com.tplus.transform.util.sql.connection.ConnectionInfo;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataSourceConnectionPool
implements ConnectionPool,
Serializable {
    private DataSource ds;
    private boolean containerManagedTransaction;
    private String user;
    private String pass;
    private ConnectionInfo connectionInfo;

    public DataSourceConnectionPool() {
        this(null);
    }

    public DataSourceConnectionPool(DataSource ds) {
        this(ds, true);
    }

    public DataSourceConnectionPool(DataSource ds, boolean containerManaged) {
        this.ds = ds;
        this.containerManagedTransaction = containerManaged;
    }

    public boolean isContainerManagedTransaction() {
        return this.containerManagedTransaction;
    }

    public void setContainerManagedTransaction(boolean containerManagedTransaction) {
        this.containerManagedTransaction = containerManagedTransaction;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void init(ConnectionInfo connectionInfo) throws SQLException {
        this.connectionInfo = connectionInfo;
        this.user = connectionInfo.getUserName();
        this.pass = connectionInfo.getPassword();
        if (this.ds == null) {
            String location = connectionInfo.getProperty("server-location");
            if (location == null) {
                throw new SQLException("server-location property not specified");
            }
            try {
                String url;
                Hashtable<String, String> ht = new Hashtable<String, String>();
                String factory = connectionInfo.getProperty("java.naming.factory.initial");
                if (factory != null) {
                    ht.put("java.naming.factory.initial", factory);
                }
                if ((url = connectionInfo.getProperty("java.naming.provider.url")) != null) {
                    ht.put("java.naming.provider.url", url);
                }
                String dsUser = connectionInfo.getProperty("java.naming.security.principal");
                String dsPassword = connectionInfo.getPropertyAllowEncrypted("java.naming.security.credentials");
                if (dsUser != null && dsPassword != null) {
                    ht.put("java.naming.security.principal", dsUser);
                    ht.put("java.naming.security.credentials", dsPassword);
                }
                InitialContext initialContext = new InitialContext(ht);
                this.ds = (DataSource)initialContext.lookup(location);
            }
            catch (NamingException e) {
                throw new SQLException("Error looking up data source at " + location + ". " + e.getMessage());
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.ds == null) {
            this.init(this.connectionInfo);
        }
        if (this.user != null || this.pass != null) {
            Connection connection = this.ds.getConnection(this.user, this.pass);
            this.initNewConnection(connection);
            return connection;
        }
        Connection connection = this.ds.getConnection();
        this.initNewConnection(connection);
        return connection;
    }

    private void initNewConnection(Connection connection) throws SQLException {
        if (!this.containerManagedTransaction) {
            connection.setAutoCommit(false);
        }
    }

    public void releaseConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void releaseConnection(Connection conn, boolean corrupted) throws SQLException {
        this.releaseConnection(conn);
    }

    public void commit(Connection con) throws SQLException {
        if (!this.containerManagedTransaction) {
            con.commit();
        }
    }

    public void rollback(Connection con) throws SQLException {
        if (!this.containerManagedTransaction) {
            con.rollback();
        }
    }

    public void closeAllConnections() throws SQLException {
    }

    public int getConnectionCount() {
        return -1;
    }

    public String getDialect() {
        if (this.connectionInfo != null) {
            return this.connectionInfo.getProperty("dialect");
        }
        return null;
    }
}

