/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.util.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class CharacterEncoder {
    protected PrintStream pStream;

    protected abstract int bytesPerAtom();

    protected abstract int bytesPerLine();

    protected void encodeBufferPrefix(OutputStream aStream) throws IOException {
        this.pStream = new PrintStream(aStream);
    }

    protected void encodeBufferSuffix(OutputStream aStream) throws IOException {
    }

    protected void encodeLinePrefix(OutputStream aStream, int aLength) throws IOException {
    }

    protected void encodeLineSuffix(OutputStream aStream) throws IOException {
        this.pStream.println();
    }

    protected abstract void encodeAtom(OutputStream var1, byte[] var2, int var3, int var4) throws IOException;

    protected int readFully(InputStream in, byte[] buffer) throws IOException {
        for (int i = 0; i < buffer.length; ++i) {
            int q = in.read();
            if (q == -1) {
                return i;
            }
            buffer[i] = (byte)q;
        }
        return buffer.length;
    }

    public void encode(InputStream inStream, OutputStream outStream) throws IOException {
        int numBytes;
        byte[] tmpbuffer = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outStream);
        while ((numBytes = this.readFully(inStream, tmpbuffer)) != 0) {
            this.encodeLinePrefix(outStream, numBytes);
            for (int j = 0; j < numBytes; j += this.bytesPerAtom()) {
                if (j + this.bytesPerAtom() <= numBytes) {
                    this.encodeAtom(outStream, tmpbuffer, j, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outStream, tmpbuffer, j, numBytes - j);
            }
            if (numBytes < this.bytesPerLine()) break;
            this.encodeLineSuffix(outStream);
        }
        this.encodeBufferSuffix(outStream);
    }

    public void encode(byte[] aBuffer, OutputStream aStream) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(aBuffer);
        this.encode(inStream, aStream);
    }

    public String encode(byte[] aBuffer) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayInputStream inStream = new ByteArrayInputStream(aBuffer);
        String retVal = null;
        try {
            this.encode(inStream, (OutputStream)outStream);
            retVal = outStream.toString("8859_1");
        }
        catch (Exception IOException2) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return retVal;
    }

    public void encodeBuffer(InputStream inStream, OutputStream outStream) throws IOException {
        int numBytes;
        byte[] tmpbuffer = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outStream);
        while ((numBytes = this.readFully(inStream, tmpbuffer)) != 0) {
            this.encodeLinePrefix(outStream, numBytes);
            for (int j = 0; j < numBytes; j += this.bytesPerAtom()) {
                if (j + this.bytesPerAtom() <= numBytes) {
                    this.encodeAtom(outStream, tmpbuffer, j, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outStream, tmpbuffer, j, numBytes - j);
            }
            this.encodeLineSuffix(outStream);
            if (numBytes >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix(outStream);
    }

    public void encodeBuffer(byte[] aBuffer, OutputStream aStream) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(aBuffer);
        this.encodeBuffer(inStream, aStream);
    }

    public String encodeBuffer(byte[] aBuffer) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayInputStream inStream = new ByteArrayInputStream(aBuffer);
        try {
            this.encodeBuffer(inStream, (OutputStream)outStream);
        }
        catch (Exception IOException2) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return outStream.toString();
    }
}

