/*
 * Decompiled with CFR 0.152.
 */
package com.transform.external.ordercsv;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.ascii.ASCIIDelimitedSimpleOutputWriter;
import com.transform.external.ordercsv.OrderCSVRecordData;

public class OrderCSVASCIIDelimitedOutputWriter
extends ASCIIDelimitedSimpleOutputWriter {
    public OrderCSVASCIIDelimitedOutputWriter(AbstractServiceElement serviceElement) {
        super(serviceElement);
        super.setDelimiter(",");
        super.setContainsHeader(false);
        super.setContainsTrailer(false);
    }

    public Object writeHeader(DataObject obj, TransformContext cxt) throws TransformException {
        return "";
    }

    public Object writeData(DataObject obj, TransformContext cxt) throws TransformException {
        StringBuffer buffer = new StringBuffer(2000);
        DataObjectSection sec = obj.getSection(0);
        int count = sec.getElementCount();
        int i = 0;
        while (i < count) {
            buffer.append(this.writeDataRecord(sec.getElement(i), cxt));
            ++i;
        }
        return buffer;
    }

    public Object writeDataRecord(DataObject obj, TransformContext cxt) throws TransformException {
        OrderCSVRecordData.Records dataObj = (OrderCSVRecordData.Records)obj;
        StringBuffer buffer = new StringBuffer(500);
        if (dataObj.isNotNull(0)) {
            this.appendField(dataObj.getAccount_Number(), buffer);
        } else {
            this.requiredFieldMissing(dataObj, 0);
        }
        if (dataObj.isNotNull(1)) {
            this.appendField(dataObj.getOrder_Type(), buffer);
        } else {
            this.requiredFieldMissing(dataObj, 1);
        }
        if (dataObj.isNotNull(2)) {
            this.appendField(dataObj.getSymbol(), buffer);
        } else {
            this.requiredFieldMissing(dataObj, 2);
        }
        if (dataObj.isNotNull(3)) {
            this.appendField(dataObj.getPrice(), buffer);
        } else {
            this.requiredFieldMissing(dataObj, 3);
        }
        if (dataObj.isNotNull(4)) {
            this.appendField(dataObj.getQuantity(), buffer);
        } else {
            this.requiredFieldMissing(dataObj, 4);
        }
        if (dataObj.isNotNull(5)) {
            this.appendField(dataObj.getTrade_Date(), buffer, "yyyyMMdd");
        } else {
            this.appendField((String)null, buffer);
        }
        buffer.append(lineSeparator);
        return buffer;
    }

    public Object writeTrailer(DataObject obj, TransformContext cxt) throws TransformException {
        return "";
    }
}

