/*
 * Decompiled with CFR 0.152.
 */
package com.volante.component.server.jdbc;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.tplus.transform.util.sql.connection.ConnectionInfo;
import com.tplus.transform.util.sql.connection.ConnectionInfoList;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import com.tplus.transform.util.sql.connection.ConnectionXML;
import com.tplus.transform.util.sql.connection.JDBCDriverConnectionPool;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractJDBCDriverConnectionPool
implements ConnectionPool,
Serializable {
    protected static Log log = LogFactory.getLog(JDBCDriverConnectionPool.class);
    String connectionStr = null;
    private transient Driver driver = null;
    String dbuserName = null;
    String dbpassword = null;
    ConnectionInfo connectionInfo;
    transient boolean initialized = false;
    transient List freeConnections = new ArrayList();
    transient List inuseConnections = new ArrayList();
    private long lastUsage;
    private long inactivityTimeout = 3600000L;

    public void init(ConnectionInfo connectionInfo) throws SQLException {
        this.connectionInfo = connectionInfo;
        this.connectionStr = connectionInfo.getURL();
        this.dbuserName = connectionInfo.getUserName();
        this.dbpassword = connectionInfo.getPassword();
        String inactivityStr = connectionInfo.getProperty("inactivity-timeout");
        if (inactivityStr != null) {
            try {
                this.inactivityTimeout = (long)Integer.parseInt(inactivityStr) * 1000L;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.onInit();
        this.initInstance();
    }

    public String getDialect() {
        if (this.connectionInfo != null) {
            return this.connectionInfo.getProperty("dialect");
        }
        return null;
    }

    protected abstract void onInit() throws SQLException;

    public int getConnectionCount() {
        return this.freeConnections.size() + this.inuseConnections.size();
    }

    void initInstance() throws SQLException {
        if (this.freeConnections == null) {
            this.freeConnections = new ArrayList();
        }
        if (this.inuseConnections == null) {
            this.inuseConnections = new ArrayList();
        }
        if (this.driver == null) {
            try {
                this.driver = this.loadDriver();
            }
            catch (Exception e) {
                SQLException sqlException = new SQLException("Error instantiating driver " + e.getMessage());
                sqlException.initCause(e);
                throw sqlException;
            }
        }
    }

    protected abstract Driver loadDriver() throws SQLException, InstantiationException, IllegalAccessException;

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public synchronized Connection getConnection() throws SQLException {
        this.initInstance();
        this.checkInactivity();
        Connection con = this.freeConnections.size() == 0 ? this.connect() : (Connection)this.freeConnections.remove(this.freeConnections.size() - 1);
        this.inuseConnections.add(con);
        this.logStatus(con, false);
        return con;
    }

    private void dumpStats() {
        System.out.println("FreeConnections = " + this.freeConnections.size() + ", usedConnections=" + this.inuseConnections.size() + ":" + System.identityHashCode(this));
    }

    protected Connection connect() throws SQLException {
        Connection con;
        Properties props = this.connectionInfo.getDriverProperties();
        try {
            con = this.driver.connect(this.connectionStr, props);
            if (con == null) {
                throw new SQLException("Error connecting to " + this.connectionInfo.getURL() + " as " + this.connectionInfo.getUserName());
            }
            boolean autoCommit = this.connectionInfo.isAutoCommit();
            con.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            log.debug("Error connecting to " + this.connectionInfo.getURL() + " as " + this.connectionInfo.getUserName(), e);
            throw e;
        }
        return con;
    }

    private void checkInactivity() {
        long currentUsage = System.currentTimeMillis();
        if (this.lastUsage != 0L && currentUsage - this.lastUsage > this.inactivityTimeout) {
            if (this.freeConnections.size() > 0) {
                this.purgeInfo("Purging connections on timeout");
            }
            this.closeFreeConnections(null);
        }
        this.lastUsage = currentUsage;
    }

    private void purgeInfo(String s) {
        log.info("[Cleanup]" + s);
    }

    public synchronized void releaseConnection(Connection con) throws SQLException {
        this.initInstance();
        if (this.inuseConnections.remove(con)) {
            this.freeConnections.add(con);
            this.logStatus(con, true);
        } else {
            AbstractJDBCDriverConnectionPool.log("Connection release error. Attempting to release unmanaged connection " + con.hashCode());
        }
    }

    public synchronized void releaseConnection(Connection con, boolean corrupted) throws SQLException {
        this.initInstance();
        if (this.inuseConnections.remove(con)) {
            if (corrupted) {
                try {
                    this.purgeInfo("Discarding possibly corrupted connection");
                    con.close();
                }
                catch (SQLException sQLException) {}
            } else {
                this.freeConnections.add(con);
            }
        }
        this.logStatus(con, true);
    }

    public void commit(Connection con) throws SQLException {
        if (!con.getAutoCommit()) {
            con.commit();
        }
    }

    public void rollback(Connection con) throws SQLException {
        if (!con.getAutoCommit()) {
            con.rollback();
        }
    }

    public synchronized void closeAllConnections() throws SQLException {
        SQLException toThrow = null;
        toThrow = this.closeInUseConnections(toThrow);
        toThrow = this.closeFreeConnections(toThrow);
        this.logStatus(null, true);
        if (toThrow != null) {
            throw toThrow;
        }
    }

    private SQLException closeInUseConnections(SQLException toThrow) {
        if (this.inuseConnections != null) {
            for (int i = 0; i < this.inuseConnections.size(); ++i) {
                Connection con = (Connection)this.inuseConnections.get(i);
                try {
                    con.close();
                    continue;
                }
                catch (SQLException e) {
                    toThrow = e;
                }
            }
            this.inuseConnections.clear();
        }
        return toThrow;
    }

    private SQLException closeFreeConnections(SQLException toThrow) {
        if (this.freeConnections != null) {
            for (int i = 0; i < this.freeConnections.size(); ++i) {
                Connection con = (Connection)this.freeConnections.get(i);
                try {
                    con.close();
                    continue;
                }
                catch (SQLException e) {
                    toThrow = e;
                }
            }
            this.freeConnections.clear();
        }
        return toThrow;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeAllConnections();
    }

    public static final ConnectionInfo getDefaultConnectionInfo() throws Exception {
        String xmlFile = System.getProperty("db.xml");
        if (xmlFile == null) {
            xmlFile = "db.xml";
        }
        if (!new File(xmlFile).exists()) {
            throw new IllegalArgumentException("File not found " + xmlFile);
        }
        String dataSource = System.getProperty("db.datasource");
        ConnectionXML connectionXML = new ConnectionXML();
        ConnectionInfoList connectionInfoList = connectionXML.read(xmlFile);
        ConnectionInfo info = null;
        info = dataSource == null || dataSource.trim().length() == 0 ? connectionInfoList.getDefaultConnection() : connectionInfoList.getConnectionInfo(dataSource);
        return info;
    }

    static void log(String str) {
    }

    void logStatus(Connection con, boolean release) {
        String str = "";
        if (con != null) {
            str = release ? "Releasing connection " : "Acquiring connection ";
            str = str + con.hashCode() + ". ";
        }
        str = str + "In use = " + this.inuseConnections.size() + " free = " + this.freeConnections.size();
        AbstractJDBCDriverConnectionPool.log(str);
    }

    public int getConnectionsInUse() {
        return this.inuseConnections.size();
    }
}

