/*
 * Decompiled with CFR 0.152.
 */
package com.volante.component.server.jdbc;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import com.volante.component.server.jdbc.LocalXAResource;
import com.volante.component.server.jdbc.ManagedConnectionPool;
import com.volante.component.server.jdbc.ResourceException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public abstract class AbstractManagedConnectionPool
implements ManagedConnectionPool {
    protected static Log log = LogFactory.getLog(AbstractManagedConnectionPool.class);
    private Map txToManagedConnectionMap = new Hashtable();
    private boolean debugEnabled;
    ConnectionPool delegatePool;

    public AbstractManagedConnectionPool(ConnectionPool connectionPool) {
        this.delegatePool = connectionPool;
    }

    public AbstractManagedConnectionPool() {
    }

    protected ConnectionPool getDelegatePool() {
        return this.delegatePool;
    }

    public void setDelegatePool(ConnectionPool delegatePool) {
        this.delegatePool = delegatePool;
    }

    protected Connection getConnectionImpl() throws SQLException {
        try {
            if (this.isTransactionActive()) {
                ActiveConnectionInfo activeConnectionInfo = this.getActiveConnectionInfo();
                if (activeConnectionInfo == null) {
                    Connection currentConnection = this.delegatePool.getConnection();
                    LocalXAResource xaResource = new LocalXAResource(currentConnection, this);
                    activeConnectionInfo = new ActiveConnectionInfo(currentConnection, xaResource);
                    this.enlist(xaResource);
                    this.setActiveConnectionInfo(activeConnectionInfo);
                }
                ++activeConnectionInfo.resourceLockCount;
                if (this.isDebugEnabled()) {
                    log.debug("[Get connection] - " + activeConnectionInfo);
                }
                return activeConnectionInfo.currentConnection;
            }
            log.warn("Getting connection outside of transaction");
            return this.delegatePool.getConnection();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.getConnectionImpl();
    }

    private boolean isDebugEnabled() {
        this.debugEnabled = log.isDebugEnabled();
        return this.debugEnabled;
    }

    public synchronized void releaseConnection(Connection con) throws SQLException {
        this.releaseConnection(con, false);
    }

    protected void releaseConnectionImpl(Connection con, boolean corrupted) throws SQLException {
        try {
            ActiveConnectionInfo activeConnectionInfo = this.getActiveConnectionInfo();
            if (activeConnectionInfo != null && activeConnectionInfo.currentConnection == con) {
                --activeConnectionInfo.resourceLockCount;
                if (this.isDebugEnabled() && corrupted) {
                    log.debug("Release managed connection with error=" + corrupted);
                }
                if (corrupted) {
                    activeConnectionInfo.setErrors(true);
                }
                if (this.isDebugEnabled()) {
                    log.debug("[Release connection] - " + activeConnectionInfo);
                }
                if (activeConnectionInfo.resourceLockCount == 0) {
                    this.delist(activeConnectionInfo.xaResource);
                }
                return;
            }
            log.warn("Releasing connection outside of transaction");
            con.commit();
            this.delegatePool.releaseConnection(con, corrupted);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.getClass().getName() + ":" + e.getMessage());
        }
    }

    public synchronized void releaseConnection(Connection con, boolean corrupted) throws SQLException {
        this.releaseConnectionImpl(con, corrupted);
    }

    public void commit(Connection con) throws SQLException {
        try {
            if (this.isTransactionActive()) {
                if (this.isDebugEnabled()) {
                    log.debug("Commit in transaction ignored - " + this.getActiveConnectionInfo());
                }
            } else {
                this.delegatePool.commit(con);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void rollback(Connection con) throws SQLException {
        try {
            if (this.isTransactionActive()) {
                if (this.isDebugEnabled()) {
                    log.debug("Rollback in transaction ignored - " + this.getActiveConnectionInfo());
                }
            } else {
                this.delegatePool.rollback(con);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void commitManagedConnection(Connection con) throws ResourceException {
        try {
            ActiveConnectionInfo activeConnectionInfo = this.getActiveConnectionInfo();
            if (this.isDebugEnabled()) {
                log.debug("[Commit managed connection] - " + activeConnectionInfo + ", Thread Id=" + Thread.currentThread().hashCode());
            }
            this.delegatePool.commit(con);
        }
        catch (Exception e) {
            throw new ResourceException(e.getMessage());
        }
    }

    public void rollbackManagedConnection(Connection con) throws ResourceException {
        try {
            ActiveConnectionInfo activeConnectionInfo = this.getActiveConnectionInfo();
            if (this.isDebugEnabled()) {
                log.debug("[Rollback managed connection]- " + activeConnectionInfo);
            }
            activeConnectionInfo.errors = true;
            this.delegatePool.rollback(con);
        }
        catch (Exception e) {
            ResourceException resourceException = new ResourceException(e.getMessage(), e);
            throw resourceException;
        }
    }

    protected abstract TransactionManager getTransactionManager() throws NamingException;

    boolean isTransactionActive() throws NamingException, SystemException {
        return this.getTransactionManager().getStatus() != 6;
    }

    Transaction getActiveTransaction() throws NamingException, SystemException {
        TransactionManager tm = this.getTransactionManager();
        Transaction trans = tm.getTransaction();
        return trans;
    }

    ActiveConnectionInfo getTransactionConnectionInfo(Transaction transaction) throws NamingException, SystemException {
        if (transaction != null) {
            ActiveConnectionInfo connectionInfo = (ActiveConnectionInfo)this.txToManagedConnectionMap.get(transaction);
            return connectionInfo;
        }
        return null;
    }

    ActiveConnectionInfo getActiveConnectionInfo() throws NamingException, SystemException {
        Transaction trans = this.getActiveTransaction();
        return this.getTransactionConnectionInfo(trans);
    }

    void setTransactionConnectionInfo(Transaction transaction, ActiveConnectionInfo activeConnectionInfo) throws NamingException, SystemException {
        this.txToManagedConnectionMap.put(transaction, activeConnectionInfo);
    }

    void setActiveConnectionInfo(ActiveConnectionInfo activeConnectionInfo) throws NamingException, SystemException {
        Transaction trans = this.getActiveTransaction();
        this.setTransactionConnectionInfo(trans, activeConnectionInfo);
    }

    void removeTransactionConnectionInfo(Transaction transaction) {
        this.txToManagedConnectionMap.remove(transaction);
    }

    private void enlist(LocalXAResource resource) throws Exception {
        TransactionManager tm = this.getTransactionManager();
        Transaction trans = tm.getTransaction();
        trans.enlistResource((XAResource)resource);
        trans.registerSynchronization((Synchronization)new TxRemover(trans));
    }

    private void delist(LocalXAResource resource) throws Exception {
        TransactionManager tm = this.getTransactionManager();
        Transaction trans = tm.getTransaction();
        trans.delistResource((XAResource)resource, 0x4000000);
    }

    private void releaseManagedConnection(Transaction transaction) throws SQLException {
        ActiveConnectionInfo transactionConnectionInfo = (ActiveConnectionInfo)this.txToManagedConnectionMap.remove(transaction);
        if (this.isDebugEnabled()) {
            log.debug("Releasing managed connection, errors = " + transactionConnectionInfo.errors);
        }
        if (transactionConnectionInfo.resourceLockCount == 0) {
            this.removeTransactionConnectionInfo(transaction);
            this.delegatePool.releaseConnection(transactionConnectionInfo.currentConnection, transactionConnectionInfo.errors);
        } else {
            log.error("JDBC Connection leak. Connection acquired within a transaction " + transactionConnectionInfo + " has not been released");
        }
        transactionConnectionInfo.xaResource = null;
        if (this.isDebugEnabled()) {
            log.debug("[Release managed connection] - " + transactionConnectionInfo);
        }
    }

    public void startTransaction(Connection con) throws ResourceException {
    }

    static class ActiveConnectionInfo {
        Connection currentConnection;
        LocalXAResource xaResource;
        boolean errors;
        int resourceLockCount = 0;

        ActiveConnectionInfo(Connection currentConnection, LocalXAResource xaResource) {
            this.currentConnection = currentConnection;
            this.xaResource = xaResource;
        }

        public boolean isErrors() {
            return this.errors;
        }

        public void setErrors(boolean errors) {
            this.errors = errors;
        }

        public String toString() {
            return "Connection=" + this.currentConnection.hashCode() + ", TranId=" + this.hashCode() + ", Thread Id=" + Thread.currentThread().hashCode();
        }
    }

    private class TxRemover
    implements Synchronization {
        private Transaction tx;

        public TxRemover(Transaction tx) {
            this.tx = tx;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                AbstractManagedConnectionPool.this.releaseManagedConnection(this.tx);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.tx = null;
        }
    }
}

