/*
 * Decompiled with CFR 0.152.
 */
package com.volante.component.server.jdbc;

import com.tplus.transform.util.sql.connection.ConnectionInfo;
import com.tplus.transform.util.sql.connection.ConnectionInfoList;
import com.tplus.transform.util.sql.connection.ConnectionXML;
import com.volante.component.server.jdbc.AbstractJDBCDriverConnectionPool;
import java.io.File;
import java.sql.Driver;
import java.sql.SQLException;

public class JDBCDriverConnectionPool
extends AbstractJDBCDriverConnectionPool {
    protected String driverClassName = null;
    private transient ClassLoader loader;
    protected Class driverClass = null;

    public JDBCDriverConnectionPool() {
        this.loader = this.getClass().getClassLoader();
    }

    public JDBCDriverConnectionPool(ClassLoader loader) {
        this.loader = loader;
    }

    public JDBCDriverConnectionPool(ConnectionInfo connectionInfo) throws SQLException {
        this.loader = this.getClass().getClassLoader();
        this.init(connectionInfo);
    }

    public JDBCDriverConnectionPool(ConnectionInfo connectionInfo, ClassLoader loader) throws SQLException {
        this.loader = loader;
        this.init(connectionInfo);
    }

    ClassLoader getClassLoader() {
        if (this.loader == null) {
            this.loader = this.getClass().getClassLoader();
        }
        return this.loader;
    }

    protected void loadDriverClass() throws SQLException {
        try {
            this.driverClass = Class.forName(this.driverClassName);
        }
        catch (Exception e) {
            SQLException sqlException = new SQLException("[resource error]Error loading driver class " + this.driverClassName + ". This could be problem with the driver itself, or that the driver is not found in the classpath.");
            sqlException.initCause(e);
            e.printStackTrace();
            log.info("Connection error ", e);
            throw sqlException;
        }
    }

    public void init(ConnectionInfo connectionInfo) throws SQLException {
        this.driverClassName = connectionInfo.getDriver();
        super.init(connectionInfo);
    }

    protected void onInit() throws SQLException {
        this.loadDriverClass();
        this.loader = null;
    }

    protected Driver loadDriver() throws SQLException, InstantiationException, IllegalAccessException {
        if (this.driverClass == null) {
            this.loadDriverClass();
        }
        Driver driver = (Driver)this.driverClass.newInstance();
        return driver;
    }

    public static final JDBCDriverConnectionPool createConnectionPool() throws Exception {
        String xmlFile = System.getProperty("db.xml");
        if (xmlFile == null) {
            xmlFile = "db.xml";
        }
        if (!new File(xmlFile).exists()) {
            throw new IllegalArgumentException("File not found " + xmlFile);
        }
        String dataSource = System.getProperty("db.datasource");
        return JDBCDriverConnectionPool.createConnectionPool(xmlFile, dataSource);
    }

    public static final JDBCDriverConnectionPool createConnectionPool(String dataSourcesFileName, String dataSource) throws Exception {
        ConnectionXML connectionXML = new ConnectionXML();
        ConnectionInfoList connectionInfoList = connectionXML.read(dataSourcesFileName);
        ConnectionInfo info = null;
        info = dataSource == null || dataSource.trim().length() == 0 ? connectionInfoList.getDefaultConnection() : connectionInfoList.getConnectionInfo(dataSource);
        if (info == null) {
            throw new IllegalArgumentException("Unable to get data source");
        }
        JDBCDriverConnectionPool connectionPool = new JDBCDriverConnectionPool(info);
        return connectionPool;
    }
}

