/*
 * Decompiled with CFR 0.152.
 */
package com.volante.component.server.jdbc;

import com.volante.component.server.jdbc.VolanteLocalXAException;
import com.volante.component.server.jdbc.VolanteXAException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class JDBCResource {
    static Map resourceBundles = new HashMap();

    static ResourceBundle getResourceBundle(Class cls) {
        String packageName = JDBCResource.getPackageName(cls);
        return JDBCResource.getResourceBundle(packageName, cls.getClassLoader());
    }

    static ResourceBundle getResourceBundle(String packageName, ClassLoader loader) {
        ResourceBundle rsrc = (ResourceBundle)resourceBundles.get(packageName);
        if (rsrc == null) {
            rsrc = ResourceBundle.getBundle(packageName + ".message", Locale.getDefault(), loader);
            resourceBundles.put(packageName, rsrc);
        }
        return rsrc;
    }

    public static String getMessage(Class cls, String messageId) {
        ResourceBundle rsrc = JDBCResource.getResourceBundle(cls);
        String message = rsrc.getString(messageId + ".message");
        return message;
    }

    public static String getErrorCode(Class cls, String messageId) {
        ResourceBundle rsrc = JDBCResource.getResourceBundle(cls);
        String code = rsrc.getString(messageId + ".code");
        return code;
    }

    static String getFormattedMessage(Class cls, String messageId, Object[] args) {
        String messageTemplate = JDBCResource.getMessage(cls, messageId);
        String message = "Unknown Error";
        if (messageTemplate != null) {
            message = MessageFormat.format(messageTemplate, args);
        }
        return message;
    }

    public static VolanteXAException createVolanteXAExceptionFormatted(String messageId, Object[] args) {
        String message = JDBCResource.getFormattedMessage(JDBCResource.class, messageId, args);
        return new VolanteXAException(message);
    }

    public static VolanteXAException createVolanteXAExceptionFormatted(String messageId, Throwable e) {
        return JDBCResource.createVolanteXAExceptionFormatted(messageId, new Object[0], e);
    }

    public static VolanteXAException createVolanteXAExceptionFormatted(String messageId, String arg, Throwable e) {
        return JDBCResource.createVolanteXAExceptionFormatted(messageId, new Object[]{arg}, e);
    }

    public static VolanteXAException createVolanteXAExceptionFormatted(String messageId, Object[] args, Throwable e) {
        String message = JDBCResource.getFormattedMessage(JDBCResource.class, messageId, args);
        return new VolanteXAException(message, e);
    }

    public static VolanteLocalXAException createVolanteLocalXAExceptionFormatted(String messageId, Throwable e) {
        return JDBCResource.createVolanteLocalXAExceptionFormatted(messageId, new Object[0], e);
    }

    public static VolanteLocalXAException createVolanteLocalXAExceptionFormatted(String messageId) {
        return JDBCResource.createVolanteLocalXAExceptionFormatted(messageId, new Object[0]);
    }

    public static VolanteLocalXAException createVolanteLocalXAExceptionFormatted(String messageId, Object[] args, Throwable e) {
        String message = JDBCResource.getFormattedMessage(JDBCResource.class, messageId, args);
        return new VolanteLocalXAException(message, e);
    }

    public static VolanteLocalXAException createVolanteLocalXAExceptionFormatted(String messageId, Object[] args) {
        String message = JDBCResource.getFormattedMessage(JDBCResource.class, messageId, args);
        return new VolanteLocalXAException(message);
    }

    private static String getPackageName(Class cls) {
        String className = cls.getName();
        String packageName = JDBCResource.getPackageName(className);
        return packageName;
    }

    private static String getPackageName(String className) {
        String packageName = className.substring(0, className.lastIndexOf(46));
        return packageName;
    }
}

