/*
 * Decompiled with CFR 0.152.
 */
package com.volante.component.server.jdbc;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.volante.component.server.jdbc.JDBCResource;
import com.volante.component.server.jdbc.ManagedConnectionPool;
import com.volante.component.server.jdbc.ResourceException;
import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class LocalXAResource
implements XAResource {
    static Log log = LogFactory.getLog("com.volante.component.server");
    private final Connection mc;
    private final ManagedConnectionPool cp;
    private static boolean warned = false;
    private Xid currentXid;

    public LocalXAResource(Connection mc, ManagedConnectionPool cp) {
        this.mc = mc;
        this.cp = cp;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.isTraceEnabled()) {
            log.trace("start, xid: " + xid + ", flags: " + flags);
        }
        if (this.currentXid != null && flags == 0) {
            throw JDBCResource.createVolanteLocalXAExceptionFormatted("RM100", new Object[]{this.currentXid, xid, String.valueOf(flags)});
        }
        if (this.currentXid == null && flags != 0) {
            throw JDBCResource.createVolanteLocalXAExceptionFormatted("RM101", new Object[]{xid, String.valueOf(flags)});
        }
        if (this.currentXid == null) {
            try {
                this.cp.startTransaction(this.mc);
            }
            catch (Throwable t) {
                log.debug("Throwable trying to start local transaction!", t);
                throw JDBCResource.createVolanteLocalXAExceptionFormatted("RM102", t);
            }
            this.currentXid = xid;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (this.isTraceEnabled()) {
            log.trace("end on xid: " + xid + " called with flags " + flags);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (xid != this.currentXid) {
            throw JDBCResource.createVolanteLocalXAExceptionFormatted("RM103", new Object[]{this.currentXid, xid});
        }
        this.currentXid = null;
        try {
            this.cp.commitManagedConnection(this.mc);
        }
        catch (ResourceException re) {
            if (this.isTraceEnabled()) {
                log.trace("commit problem: ", re);
            }
            throw JDBCResource.createVolanteLocalXAExceptionFormatted("RM104", re);
        }
    }

    public void forget(Xid xid) throws XAException {
        throw JDBCResource.createVolanteLocalXAExceptionFormatted("RM105");
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    public int prepare(Xid xid) throws XAException {
        if (!warned) {
            log.warn("Prepare called on a local tx. Use of local transactions on a jta transaction with more than one branch may result in inconsistent data in some cases of failure (This warning appears only once.)");
        }
        warned = true;
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        throw JDBCResource.createVolanteLocalXAExceptionFormatted("RM106");
    }

    public void rollback(Xid xid) throws XAException {
        if (xid != this.currentXid) {
            throw JDBCResource.createVolanteLocalXAExceptionFormatted("RM103", new Object[]{this.currentXid, xid});
        }
        this.currentXid = null;
        try {
            this.cp.rollbackManagedConnection(this.mc);
        }
        catch (ResourceException re) {
            if (this.isTraceEnabled()) {
                log.trace("rollback problem: ", re);
            }
            throw JDBCResource.createVolanteLocalXAExceptionFormatted("RM107", re);
        }
    }

    private boolean isTraceEnabled() {
        return log.isTraceEnabled();
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }
}

