/*
 * Decompiled with CFR 0.152.
 */
package com.volante.component.server.jdbc;

import com.tplus.transform.util.sql.connection.ConnectionInfo;
import com.tplus.transform.util.sql.connection.DataSourceConnectionPool;
import com.volante.component.server.jdbc.AbstractManagedConnectionPool;
import com.volante.component.server.jdbc.ManagedConnectionPool;
import com.volante.component.server.jdbc.RequiresTransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;

public class ManagedDataSourceConnectionPoolTM
extends AbstractManagedConnectionPool
implements ManagedConnectionPool,
RequiresTransactionManager {
    private TransactionManager tm;

    public ManagedDataSourceConnectionPoolTM() {
        this(ManagedDataSourceConnectionPoolTM.class.getClassLoader());
    }

    public ManagedDataSourceConnectionPoolTM(ClassLoader loader) {
        super(ManagedDataSourceConnectionPoolTM.createConnectionPool(loader));
    }

    private static DataSourceConnectionPool createConnectionPool(ClassLoader loader) {
        DataSourceConnectionPool dataSourceConnectionPool = new DataSourceConnectionPool();
        dataSourceConnectionPool.setContainerManagedTransaction(false);
        return dataSourceConnectionPool;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    protected TransactionManager getTransactionManager() throws NamingException {
        if (this.tm == null) {
            throw new NamingException("Transaction manager not set");
        }
        return this.tm;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.getDataSourcePool().getConnectionInfo();
    }

    public void init(ConnectionInfo connectionInfo) throws SQLException {
        this.getDataSourcePool().init(connectionInfo);
    }

    public void closeAllConnections() throws SQLException {
        this.getDataSourcePool().closeAllConnections();
    }

    public int getConnectionCount() {
        return this.getDataSourcePool().getConnectionCount();
    }

    private DataSourceConnectionPool getDataSourcePool() {
        return (DataSourceConnectionPool)this.getDelegatePool();
    }

    public String getDialect() {
        return this.getDelegatePool().getDialect();
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionImpl();
    }

    public void releaseConnection(Connection con) throws SQLException {
        this.releaseConnection(con, false);
    }

    public void releaseConnection(Connection con, boolean corrupted) throws SQLException {
        this.releaseConnectionImpl(con, corrupted);
    }
}

