/*
 * Decompiled with CFR 0.152.
 */
package com.volante.component.server.jdbc;

import com.tplus.transform.util.sql.connection.ConnectionInfo;
import com.volante.component.server.jdbc.AbstractManagedConnectionPool;
import com.volante.component.server.jdbc.JDBCDriverConnectionPool;
import com.volante.component.server.jdbc.ManagedConnectionPool;
import com.volante.component.server.jdbc.RequiresTransactionManager;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;

public class ManagedJDBCDriverConnectionPool
extends AbstractManagedConnectionPool
implements ManagedConnectionPool,
RequiresTransactionManager {
    private TransactionManager tm;

    public ManagedJDBCDriverConnectionPool() {
        this(ManagedJDBCDriverConnectionPool.class.getClassLoader());
    }

    public ManagedJDBCDriverConnectionPool(ClassLoader loader) {
        super(ManagedJDBCDriverConnectionPool.createConnectionPool(loader));
    }

    private static JDBCDriverConnectionPool createConnectionPool(ClassLoader loader) {
        return new JDBCDriverConnectionPool(loader);
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    protected TransactionManager getTransactionManager() throws NamingException {
        if (this.tm == null) {
            throw new NamingException("Transaction manager not set");
        }
        return this.tm;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.getJDBCDriverPool().getConnectionInfo();
    }

    public void init(ConnectionInfo connectionInfo) throws SQLException {
        this.getJDBCDriverPool().init(connectionInfo);
    }

    public void closeAllConnections() throws SQLException {
        this.getJDBCDriverPool().closeAllConnections();
    }

    public int getConnectionCount() {
        return this.getJDBCDriverPool().getConnectionCount();
    }

    private JDBCDriverConnectionPool getJDBCDriverPool() {
        return (JDBCDriverConnectionPool)this.getDelegatePool();
    }

    public String getDialect() {
        return this.getDelegatePool().getDialect();
    }
}

