/*
 * Decompiled with CFR 0.152.
 */
package com.volante.component.server.jdbc;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.tplus.transform.util.sql.connection.ConnectionInfo;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import com.tplus.transform.util.sql.connection.XADataSourceConnectionInfo;
import com.volante.component.server.jdbc.JDBCResource;
import com.volante.component.server.jdbc.ResourceException;
import com.volante.component.server.jdbc.VolanteXAException;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public class ManagedXADataSourceConnectionPool
implements ConnectionPool {
    static Log log = LogFactory.getLog("com.volante.component.server");
    Map txToManagedConnectionMap = new HashMap();
    static TransactionManager tm;
    XADataSource dataSource;
    private ConnectionInfo connectionInfo;

    public String getDialect() {
        return null;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void init(ConnectionInfo connectionInfo) throws SQLException {
        try {
            this.connectionInfo = connectionInfo;
            XADataSourceConnectionInfo xaConnectionInfo = (XADataSourceConnectionInfo)connectionInfo;
            String xaDataSourceClass = xaConnectionInfo.getProperty("data-source-class");
            Properties xaProps = xaConnectionInfo.getDataSourceProperties();
            this.dataSource = ManagedXADataSourceConnectionPool.createXADataSource(xaDataSourceClass, xaProps);
        }
        catch (VolanteXAException xaException) {
            throw new SQLException(xaException.getMessage());
        }
    }

    private static XADataSource createXADataSource(String xaDataSourceClass, Properties xaProps) throws VolanteXAException {
        String propName = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ManagedXADataSourceConnectionPool.class.getClassLoader();
            }
            Class<?> clazz = Class.forName(xaDataSourceClass, true, cl);
            XADataSource xads = (XADataSource)clazz.newInstance();
            Class[] NOCLASSES = new Class[]{};
            Iterator<Object> i = xaProps.keySet().iterator();
            while (i.hasNext()) {
                String name;
                propName = name = (String)i.next();
                String value = xaProps.getProperty(name);
                Class type = null;
                try {
                    Method getter = clazz.getMethod("get" + name, NOCLASSES);
                    type = getter.getReturnType();
                }
                catch (NoSuchMethodException e) {
                    type = String.class;
                }
                Method setter = clazz.getMethod("set" + name, type);
                PropertyEditor editor = PropertyEditorManager.findEditor(type);
                if (editor == null) {
                    throw JDBCResource.createVolanteXAExceptionFormatted("RM108", new Object[]{type});
                }
                editor.setAsText(value);
                setter.invoke((Object)xads, editor.getValue());
                log.debug("Setting " + name + " as " + editor.getValue());
            }
            return xads;
        }
        catch (ClassNotFoundException cnfe) {
            throw JDBCResource.createVolanteXAExceptionFormatted("RM109", xaDataSourceClass, (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw JDBCResource.createVolanteXAExceptionFormatted("RM110", ie);
        }
        catch (IllegalAccessException iae) {
            throw JDBCResource.createVolanteXAExceptionFormatted("RM111", iae);
        }
        catch (IllegalArgumentException iae) {
            throw JDBCResource.createVolanteXAExceptionFormatted("RM111", iae);
        }
        catch (InvocationTargetException ite) {
            throw JDBCResource.createVolanteXAExceptionFormatted("RM112", ite);
        }
        catch (NoSuchMethodException nsme) {
            throw JDBCResource.createVolanteXAExceptionFormatted("RM113", new Object[]{propName, nsme.getMessage()}, (Throwable)nsme);
        }
    }

    public void closeAllConnections() throws SQLException {
    }

    public int getConnectionCount() {
        return 0;
    }

    public synchronized Connection getConnection() throws SQLException {
        try {
            if (this.isTransactionActive()) {
                ActiveConnectionInfo activeConnectionInfo = this.getActiveConnectionInfo();
                if (activeConnectionInfo == null) {
                    XAConnection xaConnection = this.dataSource.getXAConnection();
                    activeConnectionInfo = new ActiveConnectionInfo(null, xaConnection);
                    this.setActiveConnectionInfo(activeConnectionInfo);
                }
                if (activeConnectionInfo.resourceLockCount == 0) {
                    this.enlist(activeConnectionInfo.xaResource);
                }
                activeConnectionInfo.currentConnection = activeConnectionInfo.xaConnection.getConnection();
                ++activeConnectionInfo.resourceLockCount;
                log.debug("[Get connection] - " + activeConnectionInfo);
                return activeConnectionInfo.currentConnection;
            }
            return this.dataSource.getXAConnection().getConnection();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public synchronized void releaseConnection(Connection con) throws SQLException {
        try {
            ActiveConnectionInfo activeConnectionInfo = this.getActiveConnectionInfo();
            if (activeConnectionInfo != null && activeConnectionInfo.currentConnection == con) {
                --activeConnectionInfo.resourceLockCount;
                log.debug("[Release connection] - " + activeConnectionInfo);
                if (activeConnectionInfo.resourceLockCount == 0) {
                    this.delist(activeConnectionInfo.xaResource);
                }
                return;
            }
            con.close();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void releaseConnection(Connection con, boolean corrupted) throws SQLException {
        this.releaseConnection(con);
    }

    public void commit(Connection con) throws SQLException {
        try {
            if (this.isTransactionActive()) {
                log.debug("Commit in transaction ignored - " + this.getActiveConnectionInfo());
            } else {
                con.commit();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void rollback(Connection con) throws SQLException {
        try {
            if (this.isTransactionActive()) {
                log.debug("Rollback in transaction ignored - " + this.getActiveConnectionInfo());
            } else {
                con.rollback();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    TransactionManager getTransactionManager() throws NamingException {
        if (tm == null) {
            InitialContext cxt = new InitialContext();
            tm = (TransactionManager)cxt.lookup("TransactionManager");
        }
        return tm;
    }

    boolean isTransactionActive() throws NamingException, SystemException {
        return this.getTransactionManager().getStatus() != 6;
    }

    Transaction getActiveTransaction() throws NamingException, SystemException {
        TransactionManager tm = this.getTransactionManager();
        Transaction trans = tm.getTransaction();
        return trans;
    }

    ActiveConnectionInfo getTransactionConnectionInfo(Transaction transaction) throws NamingException, SystemException {
        ActiveConnectionInfo connectionInfo = (ActiveConnectionInfo)this.txToManagedConnectionMap.get(transaction);
        return connectionInfo;
    }

    ActiveConnectionInfo getActiveConnectionInfo() throws NamingException, SystemException {
        Transaction trans = this.getActiveTransaction();
        return this.getTransactionConnectionInfo(trans);
    }

    void setTransactionConnectionInfo(Transaction transaction, ActiveConnectionInfo activeConnectionInfo) throws NamingException, SystemException {
        this.txToManagedConnectionMap.put(transaction, activeConnectionInfo);
    }

    void setActiveConnectionInfo(ActiveConnectionInfo activeConnectionInfo) throws NamingException, SystemException {
        Transaction trans = this.getActiveTransaction();
        this.setTransactionConnectionInfo(trans, activeConnectionInfo);
    }

    void removeTransactionConnectionInfo(Transaction transaction) {
        this.txToManagedConnectionMap.remove(transaction);
    }

    private void enlist(XAResource resource) throws Exception {
        TransactionManager tm = this.getTransactionManager();
        Transaction trans = tm.getTransaction();
        trans.enlistResource(resource);
        trans.registerSynchronization((Synchronization)new TxRemover(trans));
    }

    private void delist(XAResource resource) throws Exception {
        TransactionManager tm = this.getTransactionManager();
        Transaction trans = tm.getTransaction();
        trans.delistResource(resource, 0x4000000);
    }

    private void releaseManagedConnection(Transaction transaction) throws SQLException {
        ActiveConnectionInfo transactionConnectionInfo = (ActiveConnectionInfo)this.txToManagedConnectionMap.remove(transaction);
        if (transactionConnectionInfo.resourceLockCount == 0) {
            this.removeTransactionConnectionInfo(transaction);
        }
        transactionConnectionInfo.xaResource = null;
        log.debug("[Release managed connection] - " + transactionConnectionInfo);
    }

    public void startTransaction(Connection con) throws ResourceException {
    }

    static class ActiveConnectionInfo {
        Connection currentConnection;
        XAResource xaResource;
        XAConnection xaConnection;
        int resourceLockCount = 0;

        ActiveConnectionInfo(Connection currentConnection, XAConnection xaConnection) throws SQLException {
            this.currentConnection = currentConnection;
            this.xaConnection = xaConnection;
            this.xaResource = xaConnection.getXAResource();
        }

        public String toString() {
            return "TranId=" + this.hashCode() + ", Thread Id=" + Thread.currentThread().hashCode();
        }
    }

    private class TxRemover
    implements Synchronization {
        private Transaction tx;

        public TxRemover(Transaction tx) {
            this.tx = tx;
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            Map map = ManagedXADataSourceConnectionPool.this.txToManagedConnectionMap;
            synchronized (map) {
                try {
                    ManagedXADataSourceConnectionPool.this.releaseManagedConnection(this.tx);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.tx = null;
        }
    }
}

