/*
 * Decompiled with CFR 0.152.
 */
package com.volante.component.server.transaction;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public interface NestedThrowable
extends Serializable {
    public static final boolean PARENT_TRACE_ENABLED = Util.getBoolean("parentTraceEnabled", true);
    public static final boolean NESTED_TRACE_ENABLED = false;
    public static final boolean DETECT_DUPLICATE_NESTING = Util.getBoolean("detectDuplicateNesting", true);

    public Throwable getNested();

    public Throwable getCause();

    public static final class Util {
        static Log log = LogFactory.getLog("com.volante.component.server");

        private static Log getLogger() {
            if (log == null) {
                log = LogFactory.getLog("com.volante.component.server");
            }
            return log;
        }

        protected static boolean getBoolean(String name, boolean defaultValue) {
            name = NestedThrowable.class.getName() + "." + name;
            String value = System.getProperty(name, String.valueOf(defaultValue));
            log = Util.getLogger();
            log.debug(name + "=" + value);
            return new Boolean(value);
        }

        public static void checkNested(NestedThrowable parent, Throwable child) {
            Class<?> childType;
            if (!DETECT_DUPLICATE_NESTING || parent == null || child == null) {
                return;
            }
            Class<?> parentType = parent.getClass();
            if (parentType.isAssignableFrom(childType = child.getClass())) {
                log = Util.getLogger();
                log.warn("Duplicate throwable nesting of same base type: " + parentType + " is assignable from: " + childType);
            }
        }

        public static String getMessage(String msg, Throwable nested) {
            StringBuffer buff = new StringBuffer(msg == null ? "" : msg);
            if (nested != null) {
                buff.append(msg == null ? "- " : "; - ").append("nested throwable: (").append(nested).append(")");
            }
            return buff.toString();
        }

        public static void print(Throwable nested, PrintStream stream) {
            if (stream == null) {
                throw new NullPointerException("stream");
            }
        }

        public static void print(Throwable nested, PrintWriter writer) {
            if (writer == null) {
                throw new NullPointerException("writer");
            }
        }
    }
}

