/*
 * Decompiled with CFR 0.152.
 */
package com.volante.component.server.transaction;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.volante.component.server.transaction.TransactionImpl;
import com.volante.component.server.transaction.TransactionResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class TransactionManagerImpl
implements TransactionManager,
UserTransaction {
    protected static Log log = LogFactory.getLog("volante.runtime.transaction");
    private boolean trace = log.isTraceEnabled();
    private long timeOut = 1800000L;
    private volatile int commitCount;
    private volatile int rollbackCount;
    private static TransactionManagerImpl singleton = new TransactionManagerImpl();
    private ThreadLocal threadTx = new ThreadLocal();
    private Map globalIdTx = Collections.synchronizedMap(new HashMap());

    public static TransactionManagerImpl getInstance() {
        return singleton;
    }

    public TransactionManagerImpl() {
        TransactionImpl.defaultXidFactory();
        singleton = this;
    }

    public void begin() throws NotSupportedException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                this.disassociateThread(ti);
            } else {
                throw TransactionResource.createNotSupportedExceptionFormatted("RM200");
            }
        }
        long timeout = ti.timeout == 0L ? this.timeOut : ti.timeout;
        TransactionImpl tx = new TransactionImpl(timeout, this);
        this.associateThread(ti, tx);
        if ((this.globalIdTx.size() + 1) % 10 == 0) {
            // empty if block
        }
        this.globalIdTx.put(tx.getGlobalId(), tx);
        this.updateTrace();
        if (this.isTrace()) {
            log.trace("began tx: " + tx);
        }
    }

    private void updateTrace() {
        this.trace = log.isTraceEnabled();
    }

    private boolean isTrace() {
        return this.trace;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            ++this.commitCount;
            current.commit();
            this.disassociateThread(ti);
            if (this.isTrace()) {
                log.trace("commited tx: " + current);
            }
        } else {
            throw TransactionResource.createIllegalStateExceptionFormatted("RM201");
        }
    }

    public int getStatus() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                this.disassociateThread(ti);
            } else {
                return current.getStatus();
            }
        }
        return 6;
    }

    public Transaction getTransaction() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null && current.isDone()) {
            current = null;
            this.disassociateThread(ti);
        }
        return current;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (transaction != null && !(transaction instanceof TransactionImpl)) {
            throw TransactionResource.createRuntimeExceptionFormatted("RM202", transaction.getClass().getName());
        }
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                ti.tx = null;
                current = null;
            } else {
                throw TransactionResource.createIllegalStateExceptionFormatted("RM203");
            }
        }
        if (current != transaction) {
            this.associateThread(ti, (TransactionImpl)transaction);
        }
        if (this.isTrace()) {
            log.trace("resumed tx: " + ti.tx);
        }
    }

    public Transaction suspend() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            ti.tx = null;
            if (this.isTrace()) {
                log.trace("suspended tx: " + current);
            }
            if (current.isDone()) {
                current = null;
            }
        }
        return current;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            ++this.rollbackCount;
            if (!current.isDone()) {
                current.rollback();
                if (this.isTrace()) {
                    log.trace("rolled back tx: " + current);
                }
                return;
            }
            this.disassociateThread(ti);
        }
        throw TransactionResource.createIllegalStateExceptionFormatted("RM201");
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (!current.isDone()) {
                current.setRollbackOnly();
                if (this.isTrace()) {
                    log.trace("tx marked for rollback only: " + current);
                }
                return;
            }
            ti.tx = null;
        }
        throw TransactionResource.createIllegalStateExceptionFormatted("RM201");
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getThreadInfo().timeout = 1000 * seconds;
        if (this.isTrace()) {
            log.trace("tx timeout is now: " + seconds + "s");
        }
    }

    public void setDefaultTransactionTimeout(int seconds) {
        this.timeOut = 1000L * (long)seconds;
        if (this.isTrace()) {
            log.trace("default tx timeout is now: " + seconds + "s");
        }
    }

    public int getDefaultTransactionTimeout() {
        return (int)(this.timeOut / 1000L);
    }

    public Transaction disassociateThread() {
        return this.disassociateThread(this.getThreadInfo());
    }

    private Transaction disassociateThread(ThreadInfo ti) {
        TransactionImpl current = ti.tx;
        ti.tx = null;
        current.disassociateCurrentThread();
        return current;
    }

    public void associateThread(Transaction transaction) {
        if (transaction != null && !(transaction instanceof TransactionImpl)) {
            throw TransactionResource.createRuntimeExceptionFormatted("RM202", transaction.getClass().getName());
        }
        TransactionImpl transactionImpl = (TransactionImpl)transaction;
        ThreadInfo ti = this.getThreadInfo();
        ti.tx = transactionImpl;
        transactionImpl.associateCurrentThread();
    }

    private void associateThread(ThreadInfo ti, TransactionImpl transaction) {
        ti.tx = transaction;
        transaction.associateCurrentThread();
    }

    public int getTransactionCount() {
        return this.globalIdTx.size();
    }

    public long getCommitCount() {
        return this.commitCount;
    }

    public long getRollbackCount() {
        return this.rollbackCount;
    }

    void releaseTransactionImpl(TransactionImpl tx) {
        this.globalIdTx.remove(tx.getGlobalId());
    }

    private ThreadInfo getThreadInfo() {
        ThreadInfo ret = (ThreadInfo)this.threadTx.get();
        if (ret == null) {
            ret = new ThreadInfo();
            ret.timeout = this.timeOut;
            this.threadTx.set(ret);
        }
        return ret;
    }

    static class ThreadInfo {
        long timeout;
        TransactionImpl tx;

        ThreadInfo() {
        }
    }
}

