/*
 * Decompiled with CFR 0.152.
 */
package com.volante.component.server.transaction;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.volante.component.server.transaction.VolanteRollbackException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;

public class TransactionResource {
    static Map resourceBundles = new HashMap();
    protected static Log log = LogFactory.getLog(TransactionResource.class);

    static ResourceBundle getResourceBundle(Class cls) {
        String packageName = TransactionResource.getPackageName(cls);
        return TransactionResource.getResourceBundle(packageName, cls.getClassLoader());
    }

    static ResourceBundle getResourceBundle(String packageName, ClassLoader loader) {
        ResourceBundle rsrc = (ResourceBundle)resourceBundles.get(packageName);
        if (rsrc == null) {
            rsrc = ResourceBundle.getBundle(packageName + ".message", Locale.getDefault(), loader);
            resourceBundles.put(packageName, rsrc);
        }
        return rsrc;
    }

    public static String getMessage(Class cls, String messageId) {
        ResourceBundle rsrc = TransactionResource.getResourceBundle(cls);
        String message = rsrc.getString(messageId + ".message");
        return message;
    }

    public static String getErrorCode(Class cls, String messageId) {
        ResourceBundle rsrc = TransactionResource.getResourceBundle(cls);
        String code = rsrc.getString(messageId + ".code");
        return code;
    }

    static String getFormattedMessage(Class cls, String messageId, Object[] args) {
        String messageTemplate = TransactionResource.getMessage(cls, messageId);
        String message = "Unknown Error";
        if (messageTemplate != null) {
            message = MessageFormat.format(messageTemplate, args);
        }
        return message;
    }

    public static VolanteRollbackException createVolanteRollbackExceptionFormatted(String messageId, Object[] args, Throwable e) {
        String message = TransactionResource.getFormattedMessage(TransactionResource.class, messageId, args);
        return new VolanteRollbackException(message, e);
    }

    public static RollbackException createRollbackExceptionFormatted(String messageId) {
        return TransactionResource.createRollbackExceptionFormatted(messageId, new Object[0]);
    }

    public static RollbackException createRollbackExceptionFormatted(String messageId, Object[] args) {
        String message = TransactionResource.getFormattedMessage(TransactionResource.class, messageId, args);
        return new RollbackException(message);
    }

    public static RuntimeException createRuntimeExceptionFormatted(String messageId, String arg) {
        return TransactionResource.createRuntimeExceptionFormatted(messageId, new Object[]{arg});
    }

    public static RuntimeException createRuntimeExceptionFormatted(String messageId, Object[] args) {
        String message = TransactionResource.getFormattedMessage(TransactionResource.class, messageId, args);
        return new RuntimeException(message);
    }

    public static IllegalStateException createIllegalStateExceptionFormatted(String messageId, String arg) {
        return TransactionResource.createIllegalStateExceptionFormatted(messageId, new Object[]{arg});
    }

    public static IllegalStateException createIllegalStateExceptionFormatted(String messageId) {
        return TransactionResource.createIllegalStateExceptionFormatted(messageId, new Object[0]);
    }

    public static IllegalStateException createIllegalStateExceptionFormatted(String messageId, Object[] args) {
        String message = TransactionResource.getFormattedMessage(TransactionResource.class, messageId, args);
        return new IllegalStateException(message);
    }

    public static IllegalArgumentException createIllegalArgumentExceptionFormatted(String messageId) {
        return TransactionResource.createIllegalArgumentExceptionFormatted(messageId, new Object[0]);
    }

    public static IllegalArgumentException createIllegalArgumentExceptionFormatted(String messageId, String arg) {
        return TransactionResource.createIllegalArgumentExceptionFormatted(messageId, new Object[]{arg});
    }

    public static IllegalArgumentException createIllegalArgumentExceptionFormatted(String messageId, Object[] args) {
        String message = TransactionResource.getFormattedMessage(TransactionResource.class, messageId, args);
        return new IllegalArgumentException(message);
    }

    public static NotSupportedException createNotSupportedExceptionFormatted(String messageId) {
        return TransactionResource.createNotSupportedExceptionFormatted(messageId, new Object[0]);
    }

    public static NotSupportedException createNotSupportedExceptionFormatted(String messageId, Object[] args) {
        String message = TransactionResource.getFormattedMessage(TransactionResource.class, messageId, args);
        return new NotSupportedException(message);
    }

    private static String getPackageName(Class cls) {
        String className = cls.getName();
        String packageName = TransactionResource.getPackageName(className);
        return packageName;
    }

    private static String getPackageName(String className) {
        String packageName = className.substring(0, className.lastIndexOf(46));
        return packageName;
    }
}

