/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.license;

import com.tplus.license.LicenseException;
import com.tplus.license.LicenseMessage;
import com.tplus.license.ProtectParam;
import com.tplus.license.ResourceHook;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;

public class LicenseEncoder {
    private String pubStr;
    private String privStr;
    private ResourceHook res;

    public LicenseEncoder(String pubStr, String privStr, ResourceHook hook) {
        this.pubStr = pubStr;
        this.privStr = privStr;
        this.res = hook;
    }

    public ProtectParam readLicenseFile(String licfile) throws LicenseException {
        String encoded = LicenseEncoder.readFromFile(licfile);
        return this.readLicenseString(encoded);
    }

    public ProtectParam readLicenseString(String fullString) throws LicenseException {
        ProtectParam prot;
        PublicKey pub;
        String encoded = fullString;
        if (fullString.startsWith("<[")) {
            encoded = LicenseEncoder.unWrapLicenseString(fullString);
        }
        if ((pub = this.getPublicKey(this.pubStr)) != null && (prot = new ProtectParam()).decodeSigned(encoded, pub)) {
            return prot;
        }
        return null;
    }

    public String writeLicenseString(ProtectParam prot) throws LicenseException {
        PrivateKey priv = this.getPrivateKey(this.privStr);
        String encoded = prot.encodeSigned(priv);
        String wrapped = LicenseEncoder.wrapLicenseString(encoded);
        return wrapped;
    }

    public void writeLicense(ProtectParam prot, String licfile) throws LicenseException {
        String enc = this.writeLicenseString(prot);
        LicenseEncoder.writeToFile(licfile, enc);
    }

    private static void writeToFile(String filename, String str) throws LicenseException {
        try {
            FileOutputStream fs = new FileOutputStream(filename);
            PrintStream ds = new PrintStream(fs);
            String toRet = LicenseEncoder.unWrapLicenseString(str);
            ds.print(toRet);
            ds.flush();
            fs.close();
            FileUtil.elevateFileUserPermission(filename);
        }
        catch (IOException e) {
            LicenseMessage.throwError(LicenseMessage.FILE_WRITE_ERROR);
        }
    }

    private static String wrapLicenseString(String str) {
        StringBuffer toRet = new StringBuffer();
        toRet.append("<[StartEncoding]>\n");
        toRet.append(str).append("\n");
        toRet.append("<[EndEncoding]>\n");
        return toRet.toString();
    }

    private static String readFromFile(String filename) throws LicenseException {
        try {
            String s = IOUtil.readFileAsString(filename);
            return LicenseEncoder.unWrapLicenseString(s);
        }
        catch (IOException e) {
            throw new LicenseException(e.getMessage(), e);
        }
    }

    private static String unWrapLicenseString(String str) throws LicenseException {
        return LicenseEncoder.unWrapLicenseString(new StringReader(str));
    }

    private static String unWrapLicenseString(Reader fs) throws LicenseException {
        StringBuffer out = new StringBuffer();
        try {
            String line;
            BufferedReader ds = new BufferedReader(fs);
            boolean start = false;
            boolean end = false;
            while ((line = ds.readLine()) != null) {
                line.trim();
                if (line.startsWith("<[") && line.endsWith("]>")) {
                    String code = line.substring(2, line.length() - 2);
                    code.trim();
                    if (code.compareToIgnoreCase("StartEncoding") == 0) {
                        start = true;
                        continue;
                    }
                    if (code.compareToIgnoreCase("EndEncoding") != 0) continue;
                    end = true;
                    break;
                }
                out.append(line);
            }
            fs.close();
            if (start == end) {
                return out.toString();
            }
        }
        catch (IOException e) {
            LicenseMessage.throwError(LicenseMessage.FILE_READ_ERROR);
        }
        LicenseMessage.throwError(LicenseMessage.NOT_A_VALID_LICENSE_FILE);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey getPublicKey(String str) throws LicenseException {
        InputStream is = null;
        try {
            PublicKey pub;
            is = this.res.getResourceStream(str);
            ObjectInputStream ois = new ObjectInputStream(is);
            PublicKey publicKey = pub = (PublicKey)ois.readObject();
            return publicKey;
        }
        catch (Exception e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_KEY_CORRUPTION);
            e.printStackTrace();
            PublicKey publicKey = null;
            return publicKey;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private PrivateKey getPrivateKey(String str) throws LicenseException {
        try {
            InputStream is = this.res.getResourceStream(str);
            ObjectInputStream ois = new ObjectInputStream(is);
            PrivateKey priv = (PrivateKey)ois.readObject();
            return priv;
        }
        catch (Exception e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_KEY_CORRUPTION);
            e.printStackTrace();
            return null;
        }
    }

    public static String unWrapLicenseStringArray(Reader fs) throws LicenseException {
        StringBuffer out = new StringBuffer();
        try {
            String line;
            BufferedReader ds = new BufferedReader(fs);
            boolean start = false;
            boolean end = false;
            while ((line = ds.readLine()) != null) {
                line.trim();
                if (line.startsWith("<[") && line.endsWith("]>")) {
                    String code = line.substring(2, line.length() - 2);
                    code.trim();
                    if (code.compareToIgnoreCase("StartEncoding") == 0) {
                        start = true;
                        continue;
                    }
                    if (code.compareToIgnoreCase("EndEncoding") != 0) continue;
                    end = true;
                    out.append(",");
                    continue;
                }
                out.append(line);
            }
            fs.close();
            if (start == end) {
                return out.toString();
            }
        }
        catch (IOException e) {
            LicenseMessage.throwError(LicenseMessage.FILE_READ_ERROR);
        }
        LicenseMessage.throwError(LicenseMessage.NOT_A_VALID_LICENSE_FILE);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey getPublicKeyFromBytes(String str) throws LicenseException {
        InputStream keyfis = null;
        try {
            PublicKey pubKey;
            keyfis = this.res.getResourceStream(str);
            byte[] encKey = IOUtil.toByteArray(keyfis);
            keyfis.close();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey publicKey = pubKey = keyFactory.generatePublic(pubKeySpec);
            return publicKey;
        }
        catch (Exception e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_KEY_CORRUPTION);
            e.printStackTrace();
            PublicKey publicKey = null;
            return publicKey;
        }
        finally {
            if (keyfis != null) {
                try {
                    keyfis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ProtectParam[] readRuntimeLicenseString(String fullString) throws LicenseException {
        PublicKey pub;
        String encoded = fullString;
        if (fullString.startsWith("<[")) {
            encoded = LicenseEncoder.unWrapLicenseStringArray(new StringReader(fullString));
        }
        if ((pub = this.getPublicKeyFromBytes(this.pubStr)) != null) {
            String[] encodedArray = encoded.split(",");
            ProtectParam[] protArray = new ProtectParam[encodedArray.length];
            boolean flag = true;
            for (int i = 0; i < encodedArray.length; ++i) {
                protArray[i] = new ProtectParam();
                if (protArray[i].decodeSignedRuntime(encodedArray[i], pub)) continue;
                flag = false;
            }
            if (flag) {
                return protArray;
            }
        }
        return null;
    }

    public ProtectParam[] readRuntimeLicenseStringOSGI(String fullString, PublicKey pub) throws LicenseException {
        String encoded = fullString;
        if (fullString.startsWith("<[")) {
            encoded = LicenseEncoder.unWrapLicenseStringArray(new StringReader(fullString));
        }
        if (pub != null) {
            String[] encodedArray = encoded.split(",");
            ProtectParam[] protArray = new ProtectParam[encodedArray.length];
            boolean flag = true;
            for (int i = 0; i < encodedArray.length; ++i) {
                protArray[i] = new ProtectParam();
                if (protArray[i].decodeSignedRuntime(encodedArray[i], pub)) continue;
                flag = false;
            }
            if (flag) {
                return protArray;
            }
        }
        return null;
    }
}

