/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.license;

import com.tplus.transform.util.ExecUtil;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.ListUtil;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetworkMachInfo {
    protected static Log log = LogFactory.getLog(NetworkMachInfo.class);

    public static String getMachInfo() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(ip);
            byte[] mac = networkInterface.getHardwareAddress();
            return NetworkMachInfo.toMachFormat(mac);
        }
        catch (SocketException e) {
            log.error(e.getMessage(), e);
        }
        catch (UnknownHostException e) {
            log.error(e.getMessage(), e);
        }
        return null;
    }

    public static String getMachInfo(String preferred) {
        List machInfos = NetworkMachInfo.getMachInfos();
        for (int i = 0; i < machInfos.size(); ++i) {
            MachData machData = (MachData)machInfos.get(i);
            if (!machData.macAddress.equals(preferred)) continue;
            return preferred;
        }
        if (machInfos.size() > 0) {
            MachData machData = (MachData)machInfos.get(0);
            return machData.macAddress;
        }
        return null;
    }

    public static List getMachInfos() {
        ArrayList<MachData> toRet = new ArrayList<MachData>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                try {
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    byte[] mac = networkInterface.getHardwareAddress();
                    if (mac == null || mac.length == 0) continue;
                    String displayName = networkInterface.getDisplayName();
                    String macStr = NetworkMachInfo.toMachFormat(mac);
                    toRet.add(new MachData(macStr, displayName));
                }
                catch (SocketException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        catch (SocketException e) {
            log.error(e.getMessage(), e);
        }
        try {
            List ifConfigList = NetworkMachInfo.maxOSXMaCData();
            for (int i = 0; i < ifConfigList.size(); ++i) {
                MachData machData = (MachData)ifConfigList.get(i);
                if (toRet.contains(machData)) continue;
                toRet.add(machData);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        Collections.shuffle(toRet);
        Collections.sort(toRet);
        return toRet;
    }

    static List maxOSXMaCData() throws IOException {
        ArrayList macDatas = new ArrayList();
        if (ExecUtil.isMAC_OSX() || ExecUtil.isLinux()) {
            Process p = Runtime.getRuntime().exec("ifconfig");
            String ipConfigOutput = IOUtil.readStreamAsString(p.getInputStream());
            NetworkMachInfo.maxOSXMaCData(macDatas, ipConfigOutput);
        }
        return macDatas;
    }

    private static void maxOSXMaCData(List macDatas, String ipConfigOutput) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(ipConfigOutput));
        String name = null;
        StringBuffer current = new StringBuffer();
        while ((line = bufferedReader.readLine()) != null) {
            if (line.contains("flags=")) {
                NetworkMachInfo.prepareMacData(macDatas, name, current);
                current.setLength(0);
                name = StringUtils.leftStr(line, ":").trim();
            }
            current.append(line);
        }
        NetworkMachInfo.prepareMacData(macDatas, name, current);
    }

    private static void prepareMacData(List macDatas, String name, StringBuffer current) {
        String macAddress;
        if (name != null && (macAddress = MACAddressParser.parse(current.toString())) != null) {
            macDatas.add(new MachData(macAddress, name));
        }
    }

    private static String toMachFormat(byte[] mac) {
        if (mac != null) {
            StringBuffer toRet = new StringBuffer();
            for (int i = 0; i < mac.length; ++i) {
                byte b = mac[i];
                String s = Integer.toHexString(b & 0xFF);
                if (s.length() < 2) {
                    s = "0" + s;
                }
                if (toRet.length() > 0) {
                    toRet.append("-");
                }
                toRet.append(s);
            }
            return toRet.toString();
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        ArrayList macDatas = new ArrayList();
        NetworkMachInfo.maxOSXMaCData(macDatas, IOUtil.readFileAsString("N:\\Volante\\Local\\2013\\Jun\\Jun 04 2013\\Mac-Fix\\Log\\Terminal log.txt"));
        ListUtil.printList(macDatas);
    }

    public static List getAllMacAddresses() {
        ArrayList<String> macAddresses = new ArrayList<String>();
        List machInfos = NetworkMachInfo.getMachInfos();
        for (int i = 0; i < machInfos.size(); ++i) {
            MachData machData = (MachData)machInfos.get(i);
            if (machData != null) {
                macAddresses.add(machData.getMacAddress());
                continue;
            }
            log.debug("the mac address is null.");
        }
        return macAddresses;
    }

    public static List getAllIPAddresses() {
        ArrayList<String> allIPAddresses = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    String hostAddress = inetAddress.getHostAddress();
                    if (hostAddress.equals("127.0.0.1")) continue;
                    allIPAddresses.add(hostAddress);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return allIPAddresses;
    }

    public static List getAllHostNames() {
        ArrayList<String> allHostNames = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    String hostName = inetAddress.getHostName();
                    if (hostName.equals("localhost") || allHostNames.contains(hostName)) continue;
                    allHostNames.add(hostName);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return allHostNames;
    }

    static class MachData
    implements Comparable {
        String macAddress;
        String displayName;
        static String[] VIRTUAL_PREFIX = new String[]{"00:05:69", "00:0c:29", "00:50:56", "00:1c:42", "00:03:ff", "00:0f:4b", "00:16:3e", "08:00:27"};

        MachData(String macAddress, String displayName) {
            this.macAddress = StringUtils.fixNull(macAddress);
            this.displayName = StringUtils.fixNull(displayName);
        }

        String getMacAddress() {
            return this.macAddress;
        }

        String getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MachData machData = (MachData)o;
            return !(this.macAddress != null ? !this.macAddress.equals(machData.macAddress) : machData.macAddress != null);
        }

        public int hashCode() {
            return this.macAddress != null ? this.macAddress.hashCode() : 0;
        }

        public String toString() {
            return "MachData{macAddress='" + this.macAddress + '\'' + ", displayName='" + this.displayName + '\'' + '}';
        }

        public int compareTo(Object o) {
            MachData other = (MachData)o;
            int cmp = this.macAddress.compareTo(other.macAddress);
            if (cmp == 0) {
                return 0;
            }
            int morePhysical = this.getPhysicalIndex() - other.getPhysicalIndex();
            if (morePhysical != 0) {
                return -morePhysical;
            }
            return cmp;
        }

        private int getPhysicalIndex() {
            String lower = this.displayName.toLowerCase();
            if (lower.equals("en0")) {
                return 105;
            }
            if (lower.equals("eth0")) {
                return 105;
            }
            if (lower.contains("pci")) {
                return 100;
            }
            if (lower.contains("virtual")) {
                return 5;
            }
            if (lower.contains("pseudo")) {
                return 5;
            }
            if (lower.contains("enp")) {
                return 105;
            }
            if (lower.contains("en")) {
                return 105;
            }
            if (lower.contains("wlp")) {
                return 99;
            }
            if (lower.contains("docker")) {
                return 5;
            }
            if (lower.contains("br-")) {
                return 5;
            }
            if (lower.contains("vmnet")) {
                return 5;
            }
            if (lower.contains("VirtualBox")) {
                return 5;
            }
            if (lower.contains("Hyper-V")) {
                return 5;
            }
            for (int i = 0; i < VIRTUAL_PREFIX.length; ++i) {
                String virtualPrefix = VIRTUAL_PREFIX[i];
                if (!this.macAddress.startsWith(virtualPrefix)) continue;
                return 5;
            }
            if (this.macAddress.startsWith("00-00-00-00")) {
                return 0;
            }
            if (this.macAddress.startsWith("adapter")) {
                return 20;
            }
            return 25;
        }
    }

    public static class MACAddressParser {
        public static final Pattern MAC_ADDRESS = Pattern.compile("((?:[A-F0-9]{1,2}[:-]){5}[A-F0-9]{1,2})|(?:0x)(\\d{12})(?:.+ETHER)", 2);

        static String parse(String in) {
            Matcher m = MAC_ADDRESS.matcher(in);
            if (m.find()) {
                String g = m.group(2);
                if (g == null) {
                    g = m.group(1);
                }
                return g == null ? g : g.replace(':', '-');
            }
            return null;
        }
    }
}

