/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.io;

import com.tplus.transform.io.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class MemoryCacheSeekableStream
extends InputStream
implements SeekableStream {
    public static final int DEFAULT_SECTORS = 30;
    private InputStream src;
    private long pointer = 0L;
    private List data = new ArrayList();
    int length = 0;
    boolean foundEOS;
    int maxSectors = 30;
    private static final int SECTOR_SHIFT = 11;
    private static final int SECTOR_SIZE = (int)Math.pow(2.0, 11.0);
    private static final long SECTOR_MASK = SECTOR_SIZE - 1;

    public MemoryCacheSeekableStream(InputStream inputstream) {
        this.src = inputstream;
    }

    public MemoryCacheSeekableStream(InputStream inputstream, int bufferSize) {
        this.src = inputstream;
        if (bufferSize > 0) {
            this.maxSectors = (bufferSize + SECTOR_SIZE - 1) / SECTOR_SIZE;
        }
    }

    public final int available() throws IOException {
        return this.src.available();
    }

    private long readUntil(long l) throws IOException {
        int startSector;
        if (l < (long)this.length) {
            return l;
        }
        if (this.foundEOS) {
            return this.length;
        }
        int endSector = (int)(l >> 11);
        for (int k = startSector = this.length + 1 >> 11; k <= endSector; ++k) {
            byte[] sectorBytes = new byte[SECTOR_SIZE];
            this.addSector(sectorBytes);
            int remaining = SECTOR_SIZE;
            int startPos = 0;
            while (remaining > 0) {
                int k1 = this.src.read(sectorBytes, startPos, remaining);
                if (k1 == -1) {
                    this.foundEOS = true;
                    return this.length;
                }
                startPos += k1;
                remaining -= k1;
                this.length += k1;
            }
        }
        return this.length;
    }

    public boolean canSeekBackwards() {
        return true;
    }

    public long getPosition() {
        return this.pointer;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Seek index error " + pos);
        }
        this.pointer = pos;
    }

    public int read() throws IOException {
        long l = this.pointer + 1L;
        long readTill = this.readUntil(l);
        if (readTill >= l) {
            byte[] bytes = this.getSector((int)(this.pointer >> 11));
            return bytes[(int)(this.pointer++ & SECTOR_MASK)] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] toRet, int off, int len) throws IOException {
        int bytes;
        if (toRet == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > toRet.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        long readTill = this.readUntil(this.pointer + (long)SECTOR_SIZE);
        if (readTill <= this.pointer) {
            return -1;
        }
        int readCount = 0;
        do {
            this.readUntil(this.pointer + (long)SECTOR_SIZE);
        } while ((bytes = this.readImpl(toRet, off + readCount, len - readCount)) >= 0 && (readCount += bytes) < len);
        return readCount;
    }

    private int readImpl(byte[] bytes, int off, int len) throws IOException {
        int sector = (int)(this.pointer >> 11);
        byte[] sectorBytes = this.getSector(sector);
        if (sectorBytes == null) {
            throw new IOException("Attempt to seek to " + this.pointer + ", buffer underflow");
        }
        int sectorStartPtr = (int)(this.pointer & SECTOR_MASK);
        int lengthInSector = Math.min(len, SECTOR_SIZE - sectorStartPtr);
        if (this.pointer + (long)lengthInSector > (long)this.length) {
            lengthInSector = (int)((long)this.length - this.pointer);
        }
        System.arraycopy(sectorBytes, sectorStartPtr, bytes, off, lengthInSector);
        this.pointer += (long)lengthInSector;
        if (lengthInSector == 0) {
            lengthInSector = -1;
        }
        return lengthInSector;
    }

    byte[] getSector(int index) {
        byte[] bytes = (byte[])this.data.get(index);
        return bytes;
    }

    private void addSector(byte[] sectorBytes) {
        this.data.add(sectorBytes);
        if (this.data.size() > this.maxSectors) {
            int index = this.data.size() - this.maxSectors - 1;
            this.data.set(index, null);
        }
    }

    public void close() throws IOException {
        if (this.src != null) {
            this.src.close();
            this.src = null;
        }
        this.data.clear();
    }
}

