/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.io;

import com.tplus.transform.io.AbstractRandomAccessStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class RandomAccessByteArrayStream
extends AbstractRandomAccessStream {
    protected byte[] buf;
    protected int position;
    protected int length;
    private boolean isClosed = false;

    private void ensureOpen() {
    }

    public RandomAccessByteArrayStream() {
        this(32);
    }

    public RandomAccessByteArrayStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public RandomAccessByteArrayStream(byte[] buf) {
        this.buf = buf;
        this.position = 0;
        this.length = buf.length;
    }

    public synchronized void write(int b) {
        this.ensureOpen();
        int newcount = this.position + 1;
        int newLength = Math.max(this.length, newcount);
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newLength)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.length);
            this.buf = newbuf;
        }
        this.buf[this.position] = (byte)b;
        this.position = newcount;
        this.length = newLength;
    }

    public synchronized void write(byte[] b, int off, int len) {
        this.ensureOpen();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.position + len;
        int newLength = Math.max(this.length, newcount);
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newLength)];
            System.arraycopy(this.buf, 0, newbuf, 0, newLength);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.position, len);
        this.position = newcount;
        this.length = newLength;
    }

    public void seek(long pos) throws IOException {
        if (pos < (long)this.length) {
            this.position = (int)pos;
        }
    }

    public long getPosition() throws IOException {
        return this.position;
    }

    public long length() throws IOException {
        return this.length;
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.length);
    }

    public synchronized void reset() {
        this.ensureOpen();
        this.position = 0;
    }

    public synchronized byte[] toByteArray() {
        byte[] newbuf = new byte[this.length];
        System.arraycopy(this.buf, 0, newbuf, 0, this.length);
        return newbuf;
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        return new String(this.buf, 0, this.length);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.length, enc);
    }

    public String toString(int hibyte) {
        return new String(this.buf, hibyte, 0, this.length);
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
    }

    public synchronized int read() {
        return this.position < this.length ? this.buf[this.position++] & 0xFF : -1;
    }

    public synchronized int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position >= this.length) {
            return -1;
        }
        if (this.position + len > this.length) {
            len = this.length - this.position;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.position, b, off, len);
        this.position += len;
        return len;
    }

    public long skip(long n) throws IOException {
        long newPos = (long)this.position + n;
        this.seek(newPos);
        return n;
    }
}

