/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.lang.ObjectFactory;
import com.tplus.transform.lang.ObjectPool;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.util.AbstractSequentialList;
import java.util.ListIterator;

public class GenericObjectPool
implements ObjectPool {
    protected static Log log = LogFactory.getLog(ObjectPool.class);
    ObjectFactory objectFactory;
    ObjectList freeList = new ObjectList();
    ObjectList inUseList = new ObjectList();
    int maxPoolSize = Integer.MAX_VALUE;
    int maxWaitTime = 0;
    int exhaustPolicy = 0;

    public GenericObjectPool(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public int getExhaustPolicy() {
        return this.exhaustPolicy;
    }

    public void setExhaustPolicy(int exhaustPolicy) {
        this.exhaustPolicy = exhaustPolicy;
    }

    public synchronized int getFreeObjectCount() {
        return this.freeList.size();
    }

    public synchronized int getObjectCount() {
        return this.freeList.size() + this.inUseList.size();
    }

    public synchronized Object createObjectNoPool() throws IllegalAccessException, InstantiationException {
        Object newObj = this.objectFactory.create();
        return newObj;
    }

    public synchronized Object getObjectFromPool() throws IllegalAccessException, InstantiationException {
        Object obj = this.getFreeObjectFromPool();
        if (obj == null) {
            obj = this.createOrWaitForObject();
        }
        return obj;
    }

    private Object createOrWaitForObject() throws InstantiationException, IllegalAccessException {
        Object obj;
        block7: {
            if (this.getObjectCount() < this.maxPoolSize) {
                this.createNewObject();
                obj = this.getFreeObjectFromPool();
            } else {
                if (this.exhaustPolicy == 1) {
                    try {
                        this.wait(this.maxWaitTime);
                        obj = this.getFreeObjectFromPool();
                        if (obj == null) {
                            throw new RuntimeException("pool timed out");
                        }
                        break block7;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                if (this.exhaustPolicy == 0) {
                    throw new RuntimeException("pool exhausted");
                }
                throw new RuntimeException("pool exhausted");
            }
        }
        return obj;
    }

    private Object getFreeObjectFromPool() {
        if (this.freeList.isEmpty()) {
            return null;
        }
        ObjectList.ObjectEntry freeObject = this.freeList.removeObject();
        this.inUseList.add(freeObject);
        return freeObject.getObject();
    }

    public synchronized void releaseObjectToPool(Object actualObject) {
        ObjectList.ObjectEntry objectEntry = this.inUseList.removeObject(actualObject);
        if (objectEntry != null) {
            this.freeList.add(objectEntry);
            if (this.exhaustPolicy == 1) {
                this.notify();
            }
        } else {
            log.error("Attempting to release an object that does not belong to this pool " + actualObject);
        }
    }

    public synchronized void invalidateObject(Object actualObject) throws Exception {
        ObjectList.ObjectEntry objectEntry = this.inUseList.removeObject(actualObject);
        if (objectEntry == null) {
            log.error("Attempting to release an object that does not belong to this pool " + actualObject);
        }
    }

    private void createNewObject() throws InstantiationException, IllegalAccessException {
        Object newObj = this.objectFactory.create();
        this.freeList.add(newObj);
    }

    public void ensureCapacity(int capacity) throws InstantiationException, IllegalAccessException {
        int objectCount;
        for (int i = objectCount = this.getObjectCount(); i < capacity; ++i) {
            this.createNewObject();
        }
    }

    public static final class ObjectList
    extends AbstractSequentialList {
        ObjectEntry start;
        int count;

        public void add(ObjectEntry entry) {
            entry.next = this.start;
            this.start = entry;
            ++this.count;
        }

        public boolean add(Object obj) {
            this.add(new ObjectEntry(obj));
            return true;
        }

        public boolean remove(Object actualObject) {
            return this.removeObject(actualObject) != null;
        }

        public ObjectEntry removeObject(Object actualObject) {
            ObjectEntry previous = null;
            ObjectEntry current = this.start;
            while (current != null) {
                if (current.getObject() == actualObject) {
                    if (previous != null) {
                        previous.next = current.next;
                    } else {
                        this.start = current.next;
                    }
                    --this.count;
                    return current;
                }
                previous = current;
                current = current.next;
            }
            return null;
        }

        public ObjectEntry removeObject() {
            ObjectEntry freeObject = this.start;
            if (freeObject != null) {
                this.start = this.start.next;
                --this.count;
            }
            return freeObject;
        }

        public final boolean isEmpty() {
            return this.start == null;
        }

        public int size() {
            return this.count;
        }

        public ListIterator listIterator(int index) {
            return null;
        }

        static final class ObjectEntry {
            Object object;
            ObjectEntry next;

            public ObjectEntry(Object object) {
                this.object = object;
            }

            public Object getObject() {
                return this.object;
            }
        }
    }
}

