/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectionUtil {
    protected static Log LOG = LogFactory.getLog(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    public static Type resolveVariable(TypeVariable variable, Class classType) {
        return ReflectionUtil.resolveVariable(variable, classType, true);
    }

    public static Type resolveVariable(TypeVariable variable, Class classType, boolean resolveInInterfacesOnly) {
        Class aClass = ReflectionUtil.getRawType(classType);
        int index = ArrayUtilRt.find(aClass.getTypeParameters(), variable);
        if (index >= 0) {
            return variable;
        }
        Class<?>[] classes = aClass.getInterfaces();
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        for (int i = 0; i <= classes.length; ++i) {
            Type type;
            Class<Object> anInterface;
            if (i < classes.length) {
                anInterface = classes[i];
            } else {
                anInterface = aClass.getSuperclass();
                if (resolveInInterfacesOnly || anInterface == null) continue;
            }
            Type resolved = ReflectionUtil.resolveVariable(variable, anInterface);
            if (resolved instanceof Class || resolved instanceof ParameterizedType) {
                return resolved;
            }
            if (!(resolved instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)resolved;
            index = ArrayUtilRt.find(anInterface.getTypeParameters(), typeVariable);
            if (index < 0) {
                LOG.error("Cannot resolve type variable:\ntypeVariable = " + typeVariable + "\n" + "genericDeclaration = " + ReflectionUtil.declarationToString(typeVariable.getGenericDeclaration()) + "\n" + "searching in " + ReflectionUtil.declarationToString(anInterface));
            }
            Type type2 = type = i < genericInterfaces.length ? genericInterfaces[i] : aClass.getGenericSuperclass();
            if (type instanceof Class) {
                return Object.class;
            }
            if (type instanceof ParameterizedType) {
                return ReflectionUtil.getActualTypeArguments((ParameterizedType)type)[index];
            }
            throw new AssertionError((Object)("Invalid type: " + type));
        }
        return null;
    }

    public static String declarationToString(GenericDeclaration anInterface) {
        return anInterface.toString() + Arrays.asList(anInterface.getTypeParameters()) + " loaded by " + ((Class)anInterface).getClassLoader();
    }

    public static Class getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtil.getRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ReflectionUtil.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        return null;
    }

    public static Type[] getActualTypeArguments(ParameterizedType parameterizedType) {
        return parameterizedType.getActualTypeArguments();
    }

    public static Class substituteGenericType(Type genericType, Type classType) {
        if (genericType instanceof TypeVariable) {
            int index;
            Class aClass = ReflectionUtil.getRawType(classType);
            Type type = ReflectionUtil.resolveVariable((TypeVariable)genericType, aClass);
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable && classType instanceof ParameterizedType && (index = ArrayUtilRt.find(aClass.getTypeParameters(), type)) >= 0) {
                return ReflectionUtil.getRawType(ReflectionUtil.getActualTypeArguments((ParameterizedType)classType)[index]);
            }
        } else {
            return ReflectionUtil.getRawType(genericType);
        }
        return null;
    }

    public static List collectFields(Class clazz) {
        ArrayList result = new ArrayList();
        ReflectionUtil.collectFields(clazz, result);
        return result;
    }

    public static Field findField(Class clazz, final Class type, final String name) throws NoSuchFieldException {
        Field result = ReflectionUtil.processFields(clazz, new Condition(){

            public boolean value(Object o) {
                Field field = (Field)o;
                return name.equals(field.getName()) && (type == null || field.getType().equals(type));
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchFieldException("Class: " + clazz + " name: " + name + " type: " + type);
    }

    public static Field findAssignableField(Class clazz, final Class fieldType, final String fieldName) throws NoSuchFieldException {
        Field result = ReflectionUtil.processFields(clazz, new Condition(){

            public boolean value(Object o) {
                Field field = (Field)o;
                return fieldName.equals(field.getName()) && fieldType.isAssignableFrom(field.getType());
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    private static void collectFields(Class clazz, List result) {
        Field[] fields = clazz.getDeclaredFields();
        result.addAll(Arrays.asList(fields));
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtil.collectFields(superClass, result);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> each = interfaces[i];
            ReflectionUtil.collectFields(each, result);
        }
    }

    private static Field processFields(Class clazz, Condition checker) {
        Field result;
        Field[] declaredFields = clazz.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            Field field = declaredFields[i];
            if (!checker.value(field)) continue;
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (result = ReflectionUtil.processFields(superClass, checker)) != null) {
            return result;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> each = interfaces[i];
            Field result2 = ReflectionUtil.processFields(each, checker);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public static void resetField(Class clazz, Class type, String name) {
        try {
            ReflectionUtil.resetField(null, ReflectionUtil.findField(clazz, type, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(Object object, Class type, String name) {
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), type, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(Object object, String name) {
        try {
            ReflectionUtil.resetField(object, ReflectionUtil.findField(object.getClass(), null, name));
        }
        catch (NoSuchFieldException e) {
            LOG.info(e);
        }
    }

    public static void resetField(Object object, Field field) {
        field.setAccessible(true);
        Class<?> type = field.getType();
        try {
            if (type.isPrimitive()) {
                if (Boolean.TYPE.equals(type)) {
                    field.set(object, Boolean.FALSE);
                } else if (Integer.TYPE.equals(type)) {
                    field.set(object, 0);
                } else if (Double.TYPE.equals(type)) {
                    field.set(object, 0.0);
                } else if (Float.TYPE.equals(type)) {
                    field.set(object, Float.valueOf(0.0f));
                }
            } else {
                field.set(object, null);
            }
        }
        catch (IllegalAccessException e) {
            LOG.info(e);
        }
    }

    public static Method findMethod(Method[] methods, String name, Class[] parameters) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!name.equals(method.getName()) || !Arrays.equals(parameters, method.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    public static Method getMethod(Class aClass, String name, Class[] parameters) {
        return ReflectionUtil.findMethod(aClass.getMethods(), name, parameters);
    }

    public static Method getDeclaredMethod(Class aClass, String name, Class[] parameters) {
        return ReflectionUtil.findMethod(aClass.getDeclaredMethods(), name, parameters);
    }

    public static Class getMethodDeclaringClass(Class instanceClass, String name, Class[] parameters) {
        Method method = ReflectionUtil.getMethod(instanceClass, name, parameters);
        return method == null ? null : method.getDeclaringClass();
    }

    public static Object getField(Class objectClass, Object object, Class fieldType, String fieldName) {
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    public static Type resolveVariableInHierarchy(TypeVariable variable, Class aClass) {
        Type type;
        Class current = aClass;
        while ((type = ReflectionUtil.resolveVariable(variable, current, false)) == null) {
            if ((current = current.getSuperclass()) != null) continue;
            return null;
        }
        if (type instanceof TypeVariable) {
            return ReflectionUtil.resolveVariableInHierarchy((TypeVariable)type, aClass);
        }
        return type;
    }

    public static Constructor getDefaultConstructor(Class aClass) {
        try {
            Constructor constructor = aClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass, e);
        }
    }

    public static Object createInstance(Constructor constructor, Object[] args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void resetThreadLocals() {
        try {
            Field field = Thread.class.getDeclaredField("threadLocals");
            field.setAccessible(true);
            field.set(Thread.currentThread(), null);
        }
        catch (Throwable e) {
            LOG.info(e);
        }
    }

    public static Class findCallerClass(int framesToSkip) {
        try {
            Class[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    public static boolean isAssignable(Class ancestor, Class descendant) {
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    private static class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        public Class[] getStack() {
            return this.getClassContext();
        }
    }

    static interface Condition {
        public boolean value(Object var1);
    }

    static class ArrayUtilRt {
        ArrayUtilRt() {
        }

        public static int find(Object[] src, Object obj) {
            for (int i = 0; i < src.length; ++i) {
                Object o = src[i];
                if (!(o == null ? obj == null : o.equals(obj))) continue;
                return i;
            }
            return -1;
        }
    }
}

