/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.lang.DoubleUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ScaledDecimal
extends Number {
    public static final int MAX_DIGITS = 18;
    int exponent;
    long mantissa;
    public static final int MAX_EXPONENT = 63;
    static final double[] POWER_OF_TEN = new double[64];
    private static final int HIGHER = 1;
    private static final int EQUAL = 0;
    private static final int LOWER = -1;
    public static final ScaledDecimal ZERO;

    public ScaledDecimal() {
    }

    public ScaledDecimal(double value) {
        this.setValue(value);
    }

    public ScaledDecimal(int value) {
        this.setMantissaExponent(value, 0);
    }

    public ScaledDecimal(long value) {
        this.setMantissaExponent(value, 0);
    }

    public ScaledDecimal(String value) {
        this.setStringValue(value);
    }

    public ScaledDecimal(String value, boolean normalize) {
        this.setStringValue(value);
        if (normalize) {
            this.normalize();
        }
    }

    public ScaledDecimal(long mantissa, int exponent) {
        this.setMantissaExponent(mantissa, exponent);
    }

    public void normalize() {
        while (this.mantissa % 10L == 0L && this.mantissa != 0L) {
            this.mantissa /= 10L;
            ++this.exponent;
        }
    }

    public static long adjustMantissa(long mantissa, int exponent, int constantValue) throws IllegalArgumentException {
        long newMantissa;
        block5: {
            block4: {
                newMantissa = mantissa;
                if (exponent >= constantValue) break block4;
                while (exponent < constantValue) {
                    if (newMantissa % 10L == 0L) {
                        newMantissa /= 10L;
                    } else {
                        throw new IllegalArgumentException("Unable to normalize exponent of " + mantissa + "10 ^ " + exponent + " to constant value " + constantValue);
                    }
                    ++exponent;
                }
                break block5;
            }
            if (exponent <= constantValue) break block5;
            while (exponent > constantValue) {
                newMantissa *= 10L;
                --exponent;
            }
        }
        return newMantissa;
    }

    public double getValue() {
        return this.getDoubleValue();
    }

    public double getDoubleValue() {
        double value;
        if (this.exponent >= -63 && this.exponent <= 63) {
            if (this.exponent < 0) {
                double v = POWER_OF_TEN[-this.exponent];
                value = (double)this.mantissa / v;
            } else {
                double v = POWER_OF_TEN[this.exponent];
                value = (double)this.mantissa * v;
            }
        } else {
            value = this.exponent < 0 ? (double)this.mantissa / Math.pow(10.0, -this.exponent) : (double)this.mantissa * Math.pow(10.0, this.exponent);
        }
        return value;
    }

    public void setStringValue(String value) throws NumberFormatException {
        DoubleUtils.toScaledDecimal(value, this);
    }

    public void setDoubleValue(double value) {
        if (value == 0.0) {
            this.exponent = 0;
            this.mantissa = 0L;
            return;
        }
        DoubleUtils.toScaledDecimal(value, this);
    }

    public void setValue(double value) {
        this.setDoubleValue(value);
    }

    public void copyValue(ScaledDecimal ref) {
        this.exponent = ref.exponent;
        this.mantissa = ref.mantissa;
    }

    public int getExponent() {
        return this.exponent;
    }

    public void setExponent(int exponent) {
        this.exponent = exponent;
    }

    public long getMantissa() {
        return this.mantissa;
    }

    public void setMantissa(long mantissa) {
        this.mantissa = mantissa;
    }

    public void setMantissaExponent(long mantissa, int exponent) {
        this.mantissa = mantissa;
        this.exponent = exponent;
    }

    public String toValueString() {
        return this.mantissa + "* 10 ^" + this.exponent;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScaledDecimal)) {
            return false;
        }
        return this.compareTo((ScaledDecimal)obj) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int compareTo(ScaledDecimal o) {
        if (o == null) {
            return -1;
        }
        int oExponent = o.getExponent();
        long oMantissa = o.getMantissa();
        if (oExponent == this.exponent) {
            return (int)(this.mantissa - oMantissa);
        }
        int expDiff = this.exponent - oExponent;
        if (expDiff < -18) {
            byte sign1 = (byte)((this.mantissa & Long.MIN_VALUE) >> 63);
            byte sign2 = (byte)((oMantissa & Long.MIN_VALUE) >> 63);
            return sign1 < sign2 ? -1 : (sign1 == sign2 ? -1 : 1);
        }
        if (expDiff > 18) {
            byte sign1 = (byte)((this.mantissa & Long.MIN_VALUE) >> 63);
            byte sign2 = (byte)((oMantissa & Long.MIN_VALUE) >> 63);
            return sign1 < sign2 ? -1 : (sign1 == sign2 ? 1 : 1);
        }
        if (expDiff < 0) {
            long div = 1L;
            for (int i = 1; i <= -expDiff; ++i) {
                div *= 10L;
            }
            int eq = (int)(this.mantissa / div - oMantissa);
            if (eq != 0) {
                return eq;
            }
            if (this.mantissa % div != 0L) {
                int sign = (int)((this.mantissa & Long.MIN_VALUE) >> 63);
                return 1 * (1 + 2 * sign);
            }
            return 0;
        }
        long div = 1L;
        for (int i = 1; i <= expDiff; ++i) {
            div *= 10L;
        }
        int eq = (int)(this.mantissa - oMantissa / div);
        if (eq != 0) {
            return eq;
        }
        if (oMantissa % div != 0L) {
            int sign = (int)((this.mantissa & Long.MIN_VALUE) >> 63);
            return -1 * (1 + 2 * sign);
        }
        return 0;
    }

    public String toString() {
        StringBuffer numBuf = new StringBuffer();
        numBuf.insert(0, this.mantissa);
        if (this.exponent < 0) {
            int length = numBuf.length();
            int positiveExponent = 0 - this.exponent;
            int compareLength = length;
            if (this.mantissa < 0L) {
                --compareLength;
            }
            if (positiveExponent >= compareLength) {
                int position = 0;
                if (this.mantissa < 0L) {
                    position = 1;
                    --length;
                }
                while (length <= positiveExponent) {
                    numBuf.insert(position, '0');
                    ++length;
                }
                numBuf.insert(position + 1, '.');
                return numBuf.toString();
            }
            numBuf.insert(length - positiveExponent, '.');
            return numBuf.toString();
        }
        for (int i = 0; i < this.exponent; ++i) {
            numBuf.append('0');
        }
        return numBuf.toString();
    }

    public ScaledDecimal round(int decimalDigits) {
        if (-this.exponent > decimalDigits) {
            BigDecimal bigDecimal = this.bigDecimalValue();
            bigDecimal.setScale(decimalDigits, 4);
            return ScaledDecimal.valueOf(bigDecimal);
        }
        return this;
    }

    public ScaledDecimal movePointRight(int decimalDigits) {
        return new ScaledDecimal(this.mantissa, this.exponent + decimalDigits);
    }

    public ScaledDecimal movePointLeft(int decimalDigits) {
        return new ScaledDecimal(this.mantissa, this.exponent - decimalDigits);
    }

    public ScaledDecimal negate() {
        return new ScaledDecimal(-this.mantissa, this.exponent);
    }

    public ScaledDecimal setScale(int scale, int roundingMode) {
        int currentScale = -this.exponent;
        if (scale == currentScale) {
            return this;
        }
        int diffScale = scale - currentScale;
        long newMantissa = diffScale > 0 ? Math.round((double)this.mantissa * POWER_OF_TEN[diffScale]) : Math.round((double)this.mantissa / POWER_OF_TEN[-diffScale]);
        return new ScaledDecimal(newMantissa, -scale);
    }

    public ScaledDecimal abs() {
        return new ScaledDecimal(Math.abs(this.mantissa), this.exponent);
    }

    public int signum() {
        return this.mantissa < 0L ? -1 : 1;
    }

    public double doubleValue() {
        return this.getDoubleValue();
    }

    public float floatValue() {
        return (float)this.getDoubleValue();
    }

    public int intValue() {
        return (int)this.doubleValue();
    }

    public long longValue() {
        return (long)this.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(BigInteger.valueOf(this.getMantissa()), -this.getExponent());
    }

    public static ScaledDecimal valueOf(int value) {
        return new ScaledDecimal(value);
    }

    public static ScaledDecimal valueOf(long value) {
        return new ScaledDecimal(value);
    }

    public static ScaledDecimal valueOf(BigInteger value) {
        return new ScaledDecimal(value.doubleValue());
    }

    public static ScaledDecimal valueOf(BigDecimal value) {
        return new ScaledDecimal(value.unscaledValue().longValue(), -value.scale());
    }

    public static void smain(String[] args) {
        System.out.println(new ScaledDecimal("10.500", true));
        System.out.println(new ScaledDecimal("1"));
        System.out.println(new ScaledDecimal(".001"));
        System.out.println(new ScaledDecimal("12345678.90"));
    }

    static {
        try {
            for (int i = 0; i <= 63; ++i) {
                ScaledDecimal.POWER_OF_TEN[i] = Math.pow(10.0, i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ZERO = new ScaledDecimal();
    }
}

