/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.util.JavaPrettyPrinter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class StaticProxyGenerator {
    private Class interfaceClass;

    public StaticProxyGenerator(Class interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    private void generateRemoteInterface(String packageName, String className, String fileName) throws IOException {
        PrintWriter writer = new PrintWriter(new JavaPrettyPrinter(new FileWriter(fileName)));
        writer.println("package " + packageName + ";");
        String intrClassName = this.interfaceClass.getName();
        writer.println("public interface " + this.getRemoteInterfaceName(intrClassName) + " extends " + intrClassName + ", java.rmi.Remote {");
        writer.println("}");
        writer.close();
    }

    void generate(String packageName, String className, String fileName) throws IOException {
        Method declaredMethod;
        int i;
        PrintWriter writer = new PrintWriter(new JavaPrettyPrinter(new FileWriter(fileName)));
        writer.println("package " + packageName + ";");
        writer.println("import com.tplus.transform.lang.*;");
        writer.println("import java.lang.reflect.*;");
        String intrClassName = this.interfaceClass.getName();
        writer.println("public class " + className + " extends AbstractStaticProxy implements " + this.getRemoteInterfaceName(intrClassName) + " {");
        writer.println("public " + className + "() throws java.rmi.RemoteException {");
        writer.println("super();");
        writer.println("}");
        writer.println("private " + intrClassName + " getPooledObject(Method method) {");
        writer.println("return (" + intrClassName + ")super.getObjectFromPool(method);");
        writer.println("}");
        Method[] declaredMethods = this.interfaceClass.getMethods();
        for (i = 0; i < declaredMethods.length; ++i) {
            declaredMethod = declaredMethods[i];
            Class<?> returnType = declaredMethod.getReturnType();
            Class<?>[] parameterTypes = declaredMethod.getParameterTypes();
            String returnTypeName = this.getJavaName(returnType);
            String methodName = declaredMethod.getName();
            writer.print("public " + returnTypeName + " " + methodName + "(");
            StringBuffer invocationParams = new StringBuffer();
            for (int j = 0; j < parameterTypes.length; ++j) {
                Class<?> parameterType = parameterTypes[j];
                String paramTypeName = this.getJavaName(parameterType);
                String paramName = this.getParamName(parameterType, j);
                if (j > 0) {
                    invocationParams.append(", ");
                    writer.print(", ");
                }
                invocationParams.append(paramName);
                writer.print(paramTypeName);
                writer.print(" ");
                writer.print(paramName);
            }
            writer.print(")");
            Class<?>[] exceptions = declaredMethod.getExceptionTypes();
            for (int j = 0; j < exceptions.length; ++j) {
                Class<?> exception = exceptions[j];
                if (j == 0) {
                    writer.print(" throws ");
                } else {
                    writer.print(", ");
                }
                writer.print(exception.getName());
            }
            writer.println(" {");
            writer.println(intrClassName + " actualObject = getPooledObject(methods[" + i + "]);");
            writer.println("try {");
            if (!returnType.getName().equals("void")) {
                writer.print("return ");
            }
            writer.println("actualObject." + methodName + "(" + invocationParams + ");");
            writer.println("}");
            writer.println("finally {");
            writer.println("releaseObjectToPool(actualObject, methods[" + i + "]);");
            writer.println("}");
            writer.println("}");
        }
        writer.println("static Method[] methods;");
        writer.println("static {");
        writer.println("try {");
        writer.println("methods = new Method[] {");
        for (i = 0; i < declaredMethods.length; ++i) {
            declaredMethod = declaredMethods[i];
            writer.print(declaredMethod.getDeclaringClass().getName() + ".class.getMethod(\"" + declaredMethod.getName() + "\", new Class[]{");
            Class<?>[] parameterTypes = declaredMethod.getParameterTypes();
            for (int j = 0; j < parameterTypes.length; ++j) {
                Class<?> parameterType = parameterTypes[j];
                String paramTypeName = this.getJavaName(parameterType);
                if (j > 0) {
                    writer.print(", ");
                }
                writer.print(paramTypeName);
                writer.print(".class");
            }
            writer.println("}),");
        }
        writer.println("};");
        writer.println("}");
        writer.println("catch(Exception e) {");
        writer.println("throw new IncompatibleClassChangeError(e.getMessage());");
        writer.println("}");
        writer.println("}");
        writer.println("}");
        writer.close();
    }

    private String getRemoteInterfaceName(String intrClassName) {
        return StaticProxyGenerator.getLastPart(intrClassName) + "Remote";
    }

    private String getParamName(Class parameterType, int index) {
        return "p" + Integer.toString(index);
    }

    private String getJavaName(Class returnType) {
        if (returnType.isArray()) {
            return this.getJavaName(returnType.getComponentType()) + "[]";
        }
        return returnType.getName();
    }

    static String getLastPart(String qualifiedClassName) {
        int lastIndex = qualifiedClassName.lastIndexOf(46);
        String className = qualifiedClassName.substring(lastIndex + 1);
        return className;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String interfaceName = args[0];
        String qualifiedClassName = args[1];
        Class<?> intrClass = Class.forName(interfaceName);
        String fileName = new File(qualifiedClassName.replace('.', '/')).getAbsolutePath();
        String outputDir = new File(fileName).getParent();
        int lastIndex = qualifiedClassName.lastIndexOf(46);
        String className = qualifiedClassName.substring(lastIndex + 1);
        String mainFileName = new File(outputDir, className + ".java").getAbsolutePath();
        String remoteFileName = new File(outputDir, StaticProxyGenerator.getLastPart(interfaceName) + "Remote.java").getAbsolutePath();
        new File(outputDir).mkdirs();
        String packageName = qualifiedClassName.substring(0, lastIndex);
        StaticProxyGenerator staticProxyGenerator = new StaticProxyGenerator(intrClass);
        staticProxyGenerator.generate(packageName, className, mainFileName);
        staticProxyGenerator.generateRemoteInterface(packageName, className, remoteFileName);
    }
}

